/*
 * Decompiled with CFR 0.152.
 */
package org.crosswire.common.swing;

import java.awt.Component;
import javax.swing.JTable;
import javax.swing.table.TableCellRenderer;
import javax.swing.table.TableModel;
import org.crosswire.common.swing.MapCellRenderer;
import org.crosswire.common.swing.MapTableModel;

public class MapTable
extends JTable {
    private static final TableCellRenderer TCR;
    private boolean initialized = true;
    private static final long serialVersionUID = 3906091143962965817L;
    static final /* synthetic */ boolean $assertionsDisabled;

    public MapTable() {
        this(null);
    }

    public MapTable(MapTableModel mtm) {
        super(mtm);
        this.setDefaultRenderer();
    }

    public void setModel(TableModel dm) {
        if (!$assertionsDisabled && this.initialized && !(dm instanceof MapTableModel)) {
            throw new AssertionError();
        }
        super.setModel(dm);
        this.setDefaultRenderer();
    }

    public void setDefaultRenderer(Class columnclass, TableCellRenderer renderer) {
        if (!$assertionsDisabled && !(renderer instanceof MapCellRenderer)) {
            throw new AssertionError();
        }
        super.setDefaultRenderer(columnclass, renderer);
    }

    private void setDefaultRenderer() {
        if (this.initialized && this.getModel() instanceof MapTableModel) {
            for (int c = 0; c < this.getColumnCount(); ++c) {
                this.setDefaultRenderer((Class)this.getColumnClass(c), TCR);
            }
            this.adjustRowHeight();
        }
    }

    private void adjustRowHeight() {
        int height = this.getRowHeight();
        int rowcount = this.getRowCount();
        int colcount = this.getColumnCount();
        int margin = this.getRowMargin();
        for (int row = 0; row < rowcount; ++row) {
            int highest = height;
            for (int col = 0; col < colcount; ++col) {
                Component comp = this.prepareRenderer(TCR, row, col);
                highest = Math.max(highest, comp.getPreferredSize().height + 2 * margin);
            }
            if (this.getRowHeight(row) == highest) continue;
            this.setRowHeight(row, highest);
        }
    }

    static {
        $assertionsDisabled = !MapTable.class.desiredAssertionStatus();
        TCR = new MapCellRenderer();
    }
}

