/*
 * Decompiled with CFR 0.152.
 */
package org.crosswire.common.swing;

import java.awt.Color;
import java.awt.Font;
import org.crosswire.common.util.Logger;
import org.crosswire.common.util.StringUtil;

public class GuiConvert {
    private static final Logger log = Logger.getLogger(GuiConvert.class);

    private GuiConvert() {
    }

    public static Font string2Font(String value) {
        if (value == null || value.equals("")) {
            return null;
        }
        String[] values = StringUtil.split(value, ",");
        if (values.length != 3) {
            log.warn("Illegal font name: " + value);
            return null;
        }
        return new Font(values[0], Integer.parseInt(values[1]), Integer.parseInt(values[2]));
    }

    public static String font2String(Font font) {
        if (font == null || font.equals("")) {
            return "";
        }
        return font.getName() + "," + font.getStyle() + "," + font.getSize();
    }

    public static Color string2Color(String value) {
        if (value == null || value.equals("")) {
            return null;
        }
        if (value.length() != 7) {
            log.warn("Illegal colour name: " + value);
            return null;
        }
        String red = value.substring(1, 3);
        String green = value.substring(3, 5);
        String blue = value.substring(5, 7);
        return new Color(Integer.parseInt(red, 16), Integer.parseInt(green, 16), Integer.parseInt(blue, 16));
    }

    public static String color2String(Color color) {
        if (color == null) {
            return "";
        }
        String red = "00" + Integer.toHexString(color.getRed());
        String green = "00" + Integer.toHexString(color.getGreen());
        String blue = "00" + Integer.toHexString(color.getBlue());
        red = red.substring(red.length() - 2);
        green = green.substring(green.length() - 2);
        blue = blue.substring(blue.length() - 2);
        return "#" + red + green + blue;
    }
}

