/*
 * Decompiled with CFR 0.152.
 */
package org.crosswire.common.swing;

import java.awt.BorderLayout;
import java.awt.CardLayout;
import java.awt.Component;
import java.awt.Font;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import javax.swing.JButton;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.SwingUtilities;
import javax.swing.UIManager;
import org.crosswire.common.swing.ExceptionPane;
import org.crosswire.common.swing.Msg;
import org.crosswire.common.swing.NudgeButton;
import org.crosswire.common.util.Reporter;
import org.crosswire.common.util.ReporterEvent;
import org.crosswire.common.util.ReporterListener;

public class ExceptionShelf
extends JPanel {
    private List panels = new ArrayList();
    private NudgeButton toggle = new NudgeButton();
    private CardLayout card = new CardLayout();
    private int current;
    private JPanel shelf = new JPanel();
    private JPanel noproblems = this.createExceptionPanel(null);
    private int total;
    private List exceptions = new ArrayList();
    private static ShelfCaptureListener li;
    protected static final List SHELVES;
    private static Font small;
    private static boolean joined;
    private static final long serialVersionUID = 3976741375951647288L;
    static final /* synthetic */ boolean $assertionsDisabled;

    public ExceptionShelf() {
        this.toggle.addUpActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent ev) {
                ExceptionShelf.this.previousException();
            }
        });
        this.toggle.addDownActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent ev) {
                ExceptionShelf.this.nextException();
            }
        });
        this.shelf.setLayout(this.card);
        this.setLayout(new BorderLayout());
        this.add((Component)this.shelf, "Center");
        this.add((Component)this.toggle, "East");
        this.addPanel(this.noproblems);
        SHELVES.add(this);
        this.setToggles();
    }

    public void close() {
        SHELVES.remove(this);
    }

    public void addException(Throwable ex) {
        if (!$assertionsDisabled && ex == null) {
            throw new AssertionError();
        }
        if (this.total == 0) {
            this.removePanel(this.noproblems);
        }
        JPanel panel = this.createExceptionPanel(ex);
        ++this.total;
        this.exceptions.add(ex);
        this.panels.add(panel);
        this.addPanel(panel);
        this.setToggles();
    }

    public void removeException(Throwable ex) {
        if (!$assertionsDisabled && ex == null) {
            throw new AssertionError();
        }
        int index = this.exceptions.indexOf(ex);
        if (index != -1) {
            this.removePanel((JPanel)this.panels.get(index));
            --this.total;
            this.exceptions.remove(index);
            this.panels.remove(index);
            this.setToggles();
            if (this.total == 0) {
                this.addPanel(this.noproblems);
                this.card.first(this.shelf);
            }
        }
    }

    protected void previousException() {
        if (this.current < 1) {
            return;
        }
        --this.current;
        this.card.previous(this.shelf);
        this.setToggles();
    }

    protected void nextException() {
        if (this.current > this.total - 1) {
            return;
        }
        ++this.current;
        this.card.next(this.shelf);
        this.setToggles();
    }

    private void setToggles() {
        this.toggle.setUpEnabled(this.current > 0);
        this.toggle.setDownEnabled(this.current < this.total - 1);
    }

    protected void reporter() {
        if (this.total == 0) {
            JOptionPane.showMessageDialog(this, Msg.NO_PROBLEMS, Msg.STATUS.toString(), 1);
        } else {
            ExceptionPane.showExceptionDialog(this, (Throwable)this.exceptions.get(this.current));
        }
    }

    protected void remover() {
        this.removeException((Throwable)this.exceptions.get(this.current));
    }

    private void addPanel(JPanel panel) {
        String key = Integer.toString(panel.hashCode());
        this.shelf.add((Component)panel, key);
        this.card.last(this.shelf);
        this.current = this.total - 1;
    }

    private void removePanel(JPanel panel) {
        int index = this.panels.indexOf(panel);
        if (index != -1) {
            if (index == this.current && index == 0) {
                this.nextException();
                --this.current;
            }
            if (index == this.current && index != 0) {
                this.previousException();
            }
        }
        this.shelf.remove(panel);
        this.shelf.repaint();
    }

    private JPanel createExceptionPanel(Throwable ex) {
        JPanel retcode = new JPanel();
        JButton remove = new JButton(Msg.REMOVE.toString());
        JButton report = new JButton();
        if (small == null) {
            Font norm = report.getFont();
            small = new Font(norm.getName(), norm.getStyle(), norm.getSize() - 2);
        }
        if (ex == null) {
            report.setText(Msg.NO_PROBLEMS.toString());
            report.setIcon(UIManager.getIcon("OptionPane.informationIcon"));
            remove.setEnabled(false);
        } else {
            report.setText("<html>" + ExceptionPane.getHTMLDescription(ex));
            report.setIcon(UIManager.getIcon("OptionPane.errorIcon"));
            remove.setEnabled(true);
        }
        report.setFocusPainted(false);
        report.setHorizontalAlignment(2);
        remove.setFocusPainted(false);
        remove.setFont(small);
        remove.setVerticalAlignment(1);
        remove.setVerticalAlignment(3);
        remove.setMargin(new Insets(0, 3, 3, 3));
        report.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent ev) {
                ExceptionShelf.this.reporter();
            }
        });
        remove.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent ev) {
                ExceptionShelf.this.remover();
            }
        });
        retcode.setLayout(new BorderLayout());
        retcode.add((Component)report, "Center");
        retcode.add((Component)remove, "East");
        return retcode;
    }

    public static void setHelpDeskListener(boolean action) {
        if (action && !joined) {
            Reporter.addReporterListener(li);
        }
        if (!action && joined) {
            Reporter.removeReporterListener(li);
        }
        joined = action;
    }

    public static boolean isHelpDeskListener() {
        return li != null;
    }

    static {
        $assertionsDisabled = !ExceptionShelf.class.desiredAssertionStatus();
        li = new ShelfCaptureListener();
        SHELVES = new ArrayList();
    }

    static class ShelfCaptureListener
    implements ReporterListener {
        ShelfCaptureListener() {
        }

        public void reportException(final ReporterEvent ev) {
            SwingUtilities.invokeLater(new Runnable(){

                public void run() {
                    Iterator it = SHELVES.iterator();
                    while (it.hasNext()) {
                        ExceptionShelf es = (ExceptionShelf)it.next();
                        es.addException(ev.getException());
                    }
                }
            });
        }

        public void reportMessage(final ReporterEvent ev) {
            SwingUtilities.invokeLater(new Runnable(){

                public void run() {
                    Iterator it = SHELVES.iterator();
                    while (it.hasNext()) {
                        ExceptionShelf es = (ExceptionShelf)it.next();
                        es.addException(new Exception(ev.getMessage()));
                    }
                }
            });
        }
    }
}

