/*
 * Decompiled with CFR 0.152.
 */
package org.crosswire.common.swing;

import java.awt.Toolkit;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.lang.reflect.Method;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.Locale;
import java.util.Map;
import java.util.MissingResourceException;
import java.util.ResourceBundle;
import javax.swing.Action;
import javax.swing.Icon;
import javax.swing.ImageIcon;
import javax.swing.JLabel;
import javax.swing.KeyStroke;
import org.crosswire.common.swing.CWAction;
import org.crosswire.common.swing.GuiUtil;
import org.crosswire.common.util.CWClassLoader;
import org.crosswire.common.util.Logger;
import org.crosswire.common.util.StringUtil;

public class ActionFactory
implements ActionListener {
    private static final String MISSING_RESOURCE = "Missing Resource";
    private static final String METHOD_PREFIX = "do";
    private static final String SEPARATOR = ".";
    private static final String TEST = ".Name";
    private Object bean;
    private static final Logger log;
    private Map actions = new HashMap();
    static final /* synthetic */ boolean $assertionsDisabled;

    public ActionFactory(Class type, Object bean) {
        this.buildActionMap(type);
        this.bean = bean;
    }

    public void actionPerformed(ActionEvent ev) {
        String action = ev.getActionCommand();
        if (!$assertionsDisabled && action == null) {
            throw new AssertionError();
        }
        if (!$assertionsDisabled && action.length() == 0) {
            throw new AssertionError();
        }
        String methodName = METHOD_PREFIX + action;
        try {
            try {
                Method doMethod = this.bean.getClass().getDeclaredMethod(methodName, ActionEvent.class);
                doMethod.invoke(this.bean, ev);
            }
            catch (NoSuchMethodException ex) {
                Method doMethod = this.bean.getClass().getDeclaredMethod(methodName, new Class[0]);
                doMethod.invoke(this.bean, new Object[0]);
            }
        }
        catch (Exception ex) {
            log.error("Could not execute method " + this.bean.getClass().getName() + SEPARATOR + methodName + "()", ex);
        }
    }

    public Action getAction(String key) {
        CWAction action = (CWAction)this.actions.get(key);
        if (action != null) {
            return action;
        }
        log.info("Missing key: '" + key + "'. Known keys are: " + StringUtil.join(this.actions.keySet().toArray(), ", "));
        if (!$assertionsDisabled) {
            throw new AssertionError();
        }
        CWAction getOutOfJailFreeAction = new CWAction();
        getOutOfJailFreeAction.putValue("Name", key);
        getOutOfJailFreeAction.putValue("ShortDescription", MISSING_RESOURCE);
        getOutOfJailFreeAction.putValue("LongDescription", MISSING_RESOURCE);
        getOutOfJailFreeAction.setEnabled(true);
        getOutOfJailFreeAction.addActionListener(this);
        return getOutOfJailFreeAction;
    }

    public JLabel createJLabel(String key) {
        Action action = this.getAction(key);
        if (!$assertionsDisabled && action == null) {
            throw new AssertionError((Object)("Missing resource: " + key));
        }
        JLabel label = new JLabel();
        if (action != null) {
            label.setText(action.getValue("Name").toString());
            Integer mnemonic = (Integer)action.getValue("MnemonicKey");
            if (mnemonic != null) {
                label.setDisplayedMnemonic(mnemonic);
            }
        } else {
            label.setText(key);
        }
        return label;
    }

    private void buildActionMap(Class basis) {
        try {
            ResourceBundle resources = ResourceBundle.getBundle(basis.getName(), Locale.getDefault(), new CWClassLoader(basis));
            Enumeration<String> en = resources.getKeys();
            while (en.hasMoreElements()) {
                String key = en.nextElement();
                if (!key.endsWith(TEST)) continue;
                String actionName = key.substring(0, key.length() - TEST.length());
                String name = this.getActionString(resources, actionName, "Name");
                String shortDesc = this.getOptionalActionString(resources, actionName, "ShortDescription");
                String longDesc = this.getOptionalActionString(resources, actionName, "LongDescription");
                if (shortDesc == null && longDesc != null) {
                    shortDesc = longDesc;
                }
                if (longDesc == null && shortDesc != null) {
                    longDesc = shortDesc;
                }
                Icon smallIcon = this.getIcon(resources, actionName, "SmallIcon");
                Icon largeIcon = this.getIcon(resources, actionName, "LargeIcon");
                Integer mnemonic = this.getMnemonic(resources, actionName);
                KeyStroke accelerator = this.getAccelerator(resources, actionName);
                String enabledStr = this.getOptionalActionString(resources, actionName, "Enabled");
                boolean enabled = enabledStr == null ? true : Boolean.valueOf(enabledStr);
                this.createAction(actionName, name, shortDesc, longDesc, mnemonic, accelerator, smallIcon, largeIcon, enabled);
            }
        }
        catch (MissingResourceException ex) {
            log.error("Missing resource for class: " + basis.getName());
            throw ex;
        }
    }

    private String getActionString(ResourceBundle resources, String actionName, String field) {
        try {
            return resources.getString(actionName + '.' + field);
        }
        catch (MissingResourceException ex) {
            log.info("Missing key for " + actionName, ex);
            return null;
        }
    }

    private String getOptionalActionString(ResourceBundle resources, String actionName, String field) {
        try {
            return resources.getString(actionName + '.' + field);
        }
        catch (MissingResourceException ex) {
            return null;
        }
    }

    private Icon getIcon(ResourceBundle resources, String actionName, String iconName) {
        ImageIcon icon = null;
        String iconStr = this.getOptionalActionString(resources, actionName, iconName);
        if (iconStr != null && iconStr.length() > 0) {
            icon = GuiUtil.getIcon(iconStr);
        }
        return icon;
    }

    private Integer getMnemonic(ResourceBundle resources, String actionName) {
        Integer mnemonic = null;
        String mnemonicStr = this.getOptionalActionString(resources, actionName, "MnemonicKey");
        if (mnemonicStr != null && mnemonicStr.length() > 0) {
            try {
                mnemonic = new Integer(this.getInteger(mnemonicStr));
            }
            catch (NumberFormatException ex) {
                log.warn("Could not parse integer for mnemonic of action " + actionName, ex);
            }
        }
        return mnemonic;
    }

    private KeyStroke getAccelerator(ResourceBundle resources, String actionName) {
        KeyStroke accelerator = null;
        String acceleratorStr = this.getOptionalActionString(resources, actionName, "AcceleratorKey");
        if (acceleratorStr != null && acceleratorStr.length() > 0) {
            String[] modifiers = StringUtil.split(this.getActionString(resources, actionName, "AcceleratorKey.Modifiers"), ',');
            try {
                int shortcut = this.getInteger(acceleratorStr);
                int keyModifier = this.getModifier(modifiers);
                accelerator = KeyStroke.getKeyStroke(shortcut, keyModifier);
            }
            catch (NumberFormatException nfe) {
                log.warn("Could not parse integer for accelerator of action " + actionName, nfe);
            }
        }
        return accelerator;
    }

    private int getInteger(String str) throws NumberFormatException {
        int val = 0;
        int length = str.length();
        val = str.startsWith("0x") ? Integer.parseInt(str.substring(2), 16) : (length == 1 ? (int)str.charAt(0) : Integer.parseInt(str));
        return val;
    }

    private int getModifier(String[] modifiers) {
        int keyModifier = 0;
        for (int j = 0; j < modifiers.length; ++j) {
            String modifier = modifiers[j];
            if ("ctrl".equalsIgnoreCase(modifier)) {
                keyModifier |= Toolkit.getDefaultToolkit().getMenuShortcutKeyMask();
                continue;
            }
            if ("shift".equalsIgnoreCase(modifier)) {
                keyModifier |= 1;
                continue;
            }
            if (!"alt".equalsIgnoreCase(modifier)) continue;
            keyModifier |= 8;
        }
        return keyModifier;
    }

    private CWAction createAction(String acronymn, String name, String short_desc, String long_desc, Integer mnemonic, KeyStroke accel, Icon small_icon, Icon large_icon, boolean enabled) {
        CWAction cwAction = new CWAction();
        if (acronymn == null || acronymn.length() == 0) {
            log.warn("Acronymn is missing for CWAction");
        } else {
            cwAction.putValue("ActionCommandKey", acronymn);
        }
        if (name == null || name.length() == 0) {
            log.warn("Name is missing for CWAction");
            cwAction.putValue("Name", "?");
        } else {
            cwAction.putValue("Name", name);
        }
        cwAction.putValue("LargeIcon", large_icon);
        cwAction.putValue("SmallIcon", small_icon);
        cwAction.putValue("ShortDescription", short_desc);
        cwAction.putValue("LongDescription", long_desc);
        cwAction.putValue("MnemonicKey", mnemonic);
        cwAction.putValue("AcceleratorKey", accel);
        cwAction.setEnabled(enabled);
        cwAction.addActionListener(this);
        this.actions.put(acronymn, cwAction);
        return cwAction;
    }

    static {
        $assertionsDisabled = !ActionFactory.class.desiredAssertionStatus();
        log = Logger.getLogger(ActionFactory.class);
    }
}

