/*
 * Decompiled with CFR 0.152.
 */
package org.crosswire.common.config.swing;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.FlowLayout;
import java.awt.Font;
import javax.swing.BorderFactory;
import javax.swing.DefaultComboBoxModel;
import javax.swing.JButton;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTextField;
import javax.swing.border.Border;
import javax.swing.border.TitledBorder;
import org.crosswire.common.config.Choice;
import org.crosswire.common.config.swing.Field;
import org.crosswire.common.config.swing.Msg;
import org.crosswire.common.swing.ActionFactory;
import org.crosswire.common.swing.FieldLayout;
import org.crosswire.common.util.Convert;

public class StringArrayField
extends JPanel
implements Field {
    private static final String ADD = "AddStringEntry";
    private static final String REMOVE = "RemoveStringEntry";
    private static final String UPDATE = "UpdateStringEntry";
    private static final String SEPARATOR = "#";
    private ActionFactory actions = new ActionFactory(StringArrayField.class, this);
    private DefaultComboBoxModel list_model = new DefaultComboBoxModel();
    private JList list = new JList(this.list_model);
    private static final long serialVersionUID = 3256444715753878326L;

    public StringArrayField() {
        JPanel buttons = new JPanel(new FlowLayout());
        this.list.setFont(new Font("Monospaced", 0, 12));
        this.list.setSelectionMode(0);
        JScrollPane scroll = new JScrollPane();
        scroll.setViewportView(this.list);
        buttons.add(new JButton(this.actions.getAction(ADD)));
        buttons.add(new JButton(this.actions.getAction(REMOVE)));
        buttons.add(new JButton(this.actions.getAction(UPDATE)));
        TitledBorder title = BorderFactory.createTitledBorder(Msg.COMPONENT_EDITOR.toString());
        Border pad = BorderFactory.createEmptyBorder(5, 5, 5, 5);
        this.setBorder(BorderFactory.createCompoundBorder(title, pad));
        this.setLayout(new BorderLayout());
        this.add((Component)scroll, "Center");
        this.add((Component)buttons, "Last");
    }

    public void setChoice(Choice param) {
    }

    public String getValue() {
        return Convert.stringArray2String(this.getArray(), SEPARATOR);
    }

    public String[] getArray() {
        String[] retcode = new String[this.list_model.getSize()];
        for (int i = 0; i < retcode.length; ++i) {
            retcode[i] = (String)this.list_model.getElementAt(i);
        }
        return retcode;
    }

    public void setValue(String value) {
        this.setArray(Convert.string2StringArray(value, SEPARATOR));
    }

    public void setArray(String[] value) {
        this.list_model = new DefaultComboBoxModel<String>(value);
        this.list.setModel(this.list_model);
    }

    public JComponent getComponent() {
        return this;
    }

    public void doAddEntry() {
        InputPane input = new InputPane();
        if (JOptionPane.showConfirmDialog(this, input, Msg.NEW_CLASS.toString(), 2) == 0) {
            String new_name = input.name_field.getText();
            this.list_model.addElement(new_name);
        }
    }

    public void doUpdateEntry() {
        InputPane input = new InputPane();
        input.name_field.setText(this.currentValue());
        if (JOptionPane.showConfirmDialog(this, input, Msg.EDIT_CLASS.toString(), 2) == 0) {
            String new_name = input.name_field.getText();
            this.list_model.removeElement(this.currentValue());
            this.list_model.addElement(new_name);
        }
    }

    public void doRemoveEntry() {
        this.list_model.removeElement(this.currentValue());
    }

    private final String currentValue() {
        return (String)this.list_model.getElementAt(this.list.getSelectedIndex());
    }

    public static class InputPane
    extends JPanel {
        protected JTextField name_field = new JTextField();
        private static final long serialVersionUID = 3256444715753878326L;

        public InputPane() {
            super(new FieldLayout(10, 10));
            this.add(new JLabel(Msg.NAME.toString() + ':'));
            this.add(this.name_field);
            this.setBorder(BorderFactory.createEmptyBorder(10, 10, 10, 10));
        }
    }
}

