/*
 * Decompiled with CFR 0.152.
 */
package org.crosswire.jsword.passage;

import org.crosswire.common.util.MsgBase;
import org.crosswire.common.util.StringUtil;
import org.crosswire.jsword.passage.AccuracyType;
import org.crosswire.jsword.passage.Msg;
import org.crosswire.jsword.passage.NoSuchVerseException;
import org.crosswire.jsword.passage.Verse;
import org.crosswire.jsword.passage.VerseRange;

public final class VerseRangeFactory {
    private VerseRangeFactory() {
    }

    public static VerseRange fromString(String orginal) throws NoSuchVerseException {
        return VerseRangeFactory.fromString(orginal, null);
    }

    public static VerseRange fromString(String original, VerseRange basis) throws NoSuchVerseException {
        String[] parts = StringUtil.split((String)original, (String)"-");
        switch (parts.length) {
            case 1: {
                return VerseRangeFactory.fromText(original, parts[0], parts[0], basis);
            }
            case 2: {
                return VerseRangeFactory.fromText(original, parts[0], parts[1], basis);
            }
        }
        throw new NoSuchVerseException((MsgBase)Msg.RANGE_PARTS, new Object[]{"-", original});
    }

    private static VerseRange fromText(String original, String startVerseDesc, String endVerseDesc, VerseRange basis) throws NoSuchVerseException {
        String[] startParts = AccuracyType.tokenize(startVerseDesc);
        AccuracyType accuracyStart = AccuracyType.fromText(startParts, basis);
        Verse start = accuracyStart.createStartVerse(startVerseDesc, basis, startParts);
        String[] endParts = AccuracyType.tokenize(endVerseDesc);
        AccuracyType accuracyEnd = AccuracyType.fromText(endParts, accuracyStart, basis);
        Verse end = accuracyEnd.createEndVerse(endVerseDesc, start, endParts);
        return new VerseRange(original, start, end);
    }
}

