/*
 * Decompiled with CFR 0.152.
 */
package org.crosswire.jsword.passage;

import java.util.Iterator;
import org.crosswire.jsword.passage.BitwisePassage;
import org.crosswire.jsword.passage.DistinctPassage;
import org.crosswire.jsword.passage.NoSuchVerseException;
import org.crosswire.jsword.passage.Passage;
import org.crosswire.jsword.passage.RangedPassage;
import org.crosswire.jsword.passage.RestrictionType;
import org.crosswire.jsword.passage.Verse;
import org.crosswire.jsword.passage.VerseRange;

public class RocketPassage
extends BitwisePassage {
    private transient DistinctPassage distinct;
    private transient RangedPassage ranged;
    private static final long serialVersionUID = 3258125864771401268L;

    public RocketPassage() {
    }

    protected RocketPassage(String refs) throws NoSuchVerseException {
        super(refs);
    }

    public void optimizeReads() {
        this.raiseEventSuppresion();
        DistinctPassage dtemp = new DistinctPassage();
        dtemp.raiseEventSuppresion();
        dtemp.addAll(this);
        dtemp.lowerEventSuppresionAndTest();
        RangedPassage rtemp = new RangedPassage();
        rtemp.raiseEventSuppresion();
        rtemp.addAll(this);
        rtemp.lowerEventSuppresionAndTest();
        this.distinct = dtemp;
        this.ranged = rtemp;
        this.lowerEventSuppresionAndTest();
    }

    protected void optimizeWrites() {
        this.distinct = null;
        this.ranged = null;
    }

    public int countRanges(RestrictionType restrict) {
        if (this.ranged != null) {
            return this.ranged.countRanges(restrict);
        }
        return super.countRanges(restrict);
    }

    public int countVerses() {
        if (this.distinct != null) {
            return this.distinct.countVerses();
        }
        return super.countVerses();
    }

    public Iterator iterator() {
        if (this.distinct != null) {
            return this.distinct.iterator();
        }
        return super.iterator();
    }

    public Iterator rangeIterator(RestrictionType restrict) {
        if (this.ranged != null) {
            return this.ranged.rangeIterator(restrict);
        }
        return super.rangeIterator(restrict);
    }

    public boolean isEmpty() {
        if (this.distinct != null) {
            return this.distinct.isEmpty();
        }
        return super.isEmpty();
    }

    public Verse getVerseAt(int offset) throws ArrayIndexOutOfBoundsException {
        if (this.distinct != null) {
            return this.distinct.getVerseAt(offset);
        }
        return super.getVerseAt(offset);
    }

    public VerseRange getRangeAt(int offset, RestrictionType restrict) throws ArrayIndexOutOfBoundsException {
        if (this.ranged != null) {
            return this.ranged.getRangeAt(offset, restrict);
        }
        return super.getRangeAt(offset, restrict);
    }

    public int booksInPassage() {
        if (this.distinct != null) {
            return this.distinct.booksInPassage();
        }
        return super.booksInPassage();
    }

    public int chaptersInPassage(int book) throws NoSuchVerseException {
        if (this.distinct != null) {
            return this.distinct.chaptersInPassage(book);
        }
        return super.chaptersInPassage(book);
    }

    public int versesInPassage(int book, int chapter) throws NoSuchVerseException {
        if (this.distinct != null) {
            return this.distinct.versesInPassage(book, chapter);
        }
        return super.versesInPassage(book, chapter);
    }

    public boolean containsAll(Passage that) {
        if (this.ranged != null) {
            return this.ranged.containsAll(that);
        }
        return super.containsAll(that);
    }
}

