/*
 * Decompiled with CFR 0.152.
 */
package org.crosswire.jsword.passage;

import java.util.Iterator;
import java.util.NoSuchElementException;
import java.util.TreeSet;
import org.crosswire.common.util.Logger;
import org.crosswire.jsword.passage.AbstractPassage;
import org.crosswire.jsword.passage.BibleInfo;
import org.crosswire.jsword.passage.Key;
import org.crosswire.jsword.passage.KeyUtil;
import org.crosswire.jsword.passage.Msg;
import org.crosswire.jsword.passage.NoSuchVerseException;
import org.crosswire.jsword.passage.Passage;
import org.crosswire.jsword.passage.PassageUtil;
import org.crosswire.jsword.passage.RestrictionType;
import org.crosswire.jsword.passage.Verse;
import org.crosswire.jsword.passage.VerseBase;
import org.crosswire.jsword.passage.VerseRange;

public class PassageTally
extends AbstractPassage {
    public static final int ORDER_BIBLICAL = 0;
    public static final int ORDER_TALLY = 1;
    public static final int MAX_TALLY = 20000;
    protected int[] board = new int[BibleInfo.versesInBible()];
    private int max;
    private int order = 0;
    private static final Logger log;
    private static final long serialVersionUID = 3761128240928274229L;
    static final /* synthetic */ boolean $assertionsDisabled;

    public PassageTally() {
    }

    public PassageTally(String refs) throws NoSuchVerseException {
        super(refs);
        this.addVerses(refs);
    }

    public void setOrdering(int order) {
        if (order != 0 && order != 1) {
            throw new IllegalArgumentException(Msg.TALLY_ERROR_ORDER.toString());
        }
        this.order = order;
    }

    public int getOrdering() {
        return this.order;
    }

    public Object clone() {
        PassageTally copy = (PassageTally)super.clone();
        copy.board = (int[])this.board.clone();
        return copy;
    }

    public String toString() {
        return this.getName(0);
    }

    public String getName() {
        return this.getName(0);
    }

    public String getName(int max_count) {
        StringBuffer retcode;
        block9: {
            if (PassageUtil.isPersistentNaming() && this.originalName != null) {
                return this.originalName;
            }
            retcode = new StringBuffer();
            try {
                if (this.order == 0) {
                    Iterator it = this.rangeIterator(RestrictionType.NONE);
                    Verse current = null;
                    while (it.hasNext()) {
                        VerseRange range = (VerseRange)it.next();
                        retcode.append(range.getName(current));
                        if (it.hasNext()) {
                            retcode.append(", ");
                        }
                        current = range.getStart();
                    }
                } else {
                    if (max_count == 0) {
                        max_count = Integer.MAX_VALUE;
                    }
                    OrderedVerseIterator it = new OrderedVerseIterator(this.board);
                    Verse current = null;
                    int count = 0;
                    while (it.hasNext() && count < max_count) {
                        Verse verse = (Verse)it.next();
                        retcode.append(verse.getName(current));
                        current = verse;
                        if (!it.hasNext() || ++count >= max_count) continue;
                        retcode.append(", ");
                    }
                }
            }
            catch (Exception ex) {
                if ($assertionsDisabled) break block9;
                throw new AssertionError((Object)ex);
            }
        }
        return retcode.toString();
    }

    public String getNameAndTally() {
        return this.getNameAndTally(0);
    }

    public String getNameAndTally(int max_count) {
        StringBuffer retcode;
        block4: {
            retcode = new StringBuffer();
            if (max_count == 0) {
                max_count = Integer.MAX_VALUE;
            }
            try {
                OrderedVerseIterator it = new OrderedVerseIterator(this.board);
                int count = 0;
                while (it.hasNext() && count < max_count) {
                    Verse verse = (Verse)it.next();
                    retcode.append(verse.getName());
                    retcode.append(" (");
                    retcode.append(100 * it.lastRank() / this.max);
                    retcode.append("%)");
                    if (!it.hasNext() || ++count >= max_count) continue;
                    retcode.append(", ");
                }
            }
            catch (Exception ex) {
                if ($assertionsDisabled) break block4;
                throw new AssertionError((Object)ex);
            }
        }
        return retcode.toString();
    }

    public Iterator iterator() {
        if (this.order == 0) {
            return new VerseIterator();
        }
        return new OrderedVerseIterator(this.board);
    }

    public Iterator rangeIterator(RestrictionType restrict) {
        if (this.order == 0) {
            return new AbstractPassage.VerseRangeIterator(this.iterator(), restrict);
        }
        return new OrderedVerseRangeIterator(this.iterator(), this.board);
    }

    public boolean contains(VerseBase that) {
        Verse[] verses = PassageTally.toVerseArray(that);
        for (int i = 0; i < verses.length; ++i) {
            if (this.board[verses[i].getOrdinal() - 1] != 0) continue;
            return false;
        }
        return true;
    }

    public int getTallyOf(Verse verse) {
        return this.board[verse.getOrdinal() - 1];
    }

    public int getIndexOf(Verse verse) {
        int reply = 0;
        Iterator it = this.iterator();
        while (it.hasNext()) {
            if (verse.equals(it.next())) {
                return reply;
            }
            ++reply;
        }
        return -1;
    }

    public void add(VerseBase that) {
        this.optimizeWrites();
        this.alterVerseBase(that, 1);
        this.fireIntervalAdded(this, null, null);
    }

    public void add(VerseBase that, int count) {
        this.optimizeWrites();
        this.alterVerseBase(that, count);
        this.fireIntervalAdded(this, null, null);
    }

    public void unAdd(VerseBase that) {
        this.optimizeWrites();
        this.alterVerseBase(that, -1);
        this.fireIntervalRemoved(this, null, null);
    }

    public void remove(VerseBase that) {
        this.optimizeWrites();
        Verse[] verses = PassageTally.toVerseArray(that);
        for (int i = 0; i < verses.length; ++i) {
            this.kill(verses[i].getOrdinal());
        }
        this.fireIntervalRemoved(this, null, null);
    }

    public void addAll(Key that) {
        this.optimizeWrites();
        if (that instanceof PassageTally) {
            PassageTally that_rt = (PassageTally)that;
            int vib = BibleInfo.versesInBible();
            for (int i = 0; i < vib; ++i) {
                this.increment(i + 1, that_rt.board[i]);
            }
            this.incrementMax(that_rt.max);
        } else {
            Iterator it = that.iterator();
            while (it.hasNext()) {
                Verse verse = (Verse)it.next();
                this.increment(verse.getOrdinal(), 1);
            }
            this.incrementMax(1);
        }
        this.fireIntervalAdded(this, null, null);
    }

    public void unAddAll(Passage that) {
        this.optimizeWrites();
        if (that instanceof PassageTally) {
            PassageTally that_rt = (PassageTally)that;
            int vib = BibleInfo.versesInBible();
            for (int i = 0; i < vib; ++i) {
                this.increment(i, -that_rt.board[i - 1]);
            }
        } else {
            Iterator it = that.iterator();
            while (it.hasNext()) {
                Verse verse = (Verse)it.next();
                this.increment(verse.getOrdinal(), -1);
            }
        }
        this.fireIntervalRemoved(this, null, null);
    }

    public void removeAll(Key key) {
        Passage that = KeyUtil.getPassage(key);
        this.optimizeWrites();
        if (that instanceof PassageTally) {
            PassageTally that_rt = (PassageTally)that;
            int vib = BibleInfo.versesInBible();
            for (int i = 0; i < vib; ++i) {
                if (that_rt.board[i] == 0) continue;
                this.kill(i + 1);
            }
        } else {
            Iterator it = that.iterator();
            while (it.hasNext()) {
                Verse verse = (Verse)it.next();
                this.kill(verse.getOrdinal());
            }
        }
        this.fireIntervalRemoved(this, null, null);
    }

    public void clear() {
        this.optimizeWrites();
        int vib = BibleInfo.versesInBible();
        for (int i = 0; i < vib; ++i) {
            this.board[i] = 0;
        }
        this.fireIntervalRemoved(this, null, null);
    }

    public Passage trimVerses(int count) {
        this.optimizeWrites();
        Passage remainder = null;
        int i = 0;
        boolean overflow = false;
        remainder = (Passage)this.clone();
        Iterator it = this.iterator();
        while (it.hasNext()) {
            Verse verse = (Verse)it.next();
            if (i > count) {
                this.remove(verse);
                overflow = true;
            } else {
                remainder.remove(verse);
            }
            ++i;
        }
        if (overflow) {
            return remainder;
        }
        return null;
    }

    public void flatten() {
        this.optimizeWrites();
        int vib = BibleInfo.versesInBible();
        for (int i = 0; i < vib; ++i) {
            if (this.board[i] == 0) continue;
            this.board[i] = 1;
        }
        this.max = 1;
    }

    public void blur(int verses, RestrictionType restrict) {
        this.optimizeWrites();
        this.raiseNormalizeProtection();
        if (verses < 0) {
            throw new IllegalArgumentException(Msg.ERROR_BLUR.toString());
        }
        if (!restrict.equals(RestrictionType.NONE)) {
            log.warn("Restrict=" + restrict + " is not properly supported.");
            PassageTally temp = (PassageTally)this.clone();
            Iterator it = temp.rangeIterator(RestrictionType.NONE);
            while (it.hasNext()) {
                VerseRange range = (VerseRange)it.next();
                for (int i = 0; i <= verses; ++i) {
                    this.add(restrict.blur(range, i, i));
                }
            }
        } else {
            int[] new_board = new int[BibleInfo.versesInBible()];
            int vib = BibleInfo.versesInBible();
            for (int i = 0; i < vib; ++i) {
                int k;
                int j;
                if (this.board[i] == 0) continue;
                for (j = -verses; j < 0; ++j) {
                    k = i + j;
                    if (k < 0) continue;
                    int n = k;
                    new_board[n] = new_board[n] + (this.board[i] + verses + j);
                }
                int n = i;
                new_board[n] = new_board[n] + (this.board[i] + verses);
                for (j = 1; j <= verses; ++j) {
                    k = i + j;
                    if (k >= vib) continue;
                    int n2 = k;
                    new_board[n2] = new_board[n2] + (this.board[i] + verses - j);
                }
            }
            this.board = new_board;
        }
        this.resetMax();
        this.lowerNormalizeProtection();
        this.fireIntervalAdded(this, null, null);
    }

    private void resetMax() {
        this.optimizeWrites();
        int vib = BibleInfo.versesInBible();
        this.max = 0;
        for (int i = 0; i < vib; ++i) {
            if (this.board[i] <= this.max) continue;
            this.max = this.board[i];
        }
    }

    private void alterVerseBase(VerseBase that, int tally) {
        Verse[] verses = PassageTally.toVerseArray(that);
        for (int i = 0; i < verses.length; ++i) {
            this.increment(verses[i].getOrdinal(), tally);
        }
        if (tally > 0) {
            this.incrementMax(tally);
        }
    }

    private final void increment(int ord, int tally) {
        int n = ord - 1;
        this.board[n] = this.board[n] + tally;
        if (this.board[ord - 1] > 20000) {
            this.board[ord - 1] = 20000;
        }
        if (this.board[ord - 1] < 0) {
            this.board[ord - 1] = 0;
        }
    }

    private final void incrementMax(int tally) {
        this.max += tally;
        if (this.max > 20000) {
            this.max = 20000;
        }
        if (this.max < 0) {
            this.max = 0;
        }
    }

    private final void kill(int ord) {
        this.board[ord - 1] = 0;
    }

    static {
        $assertionsDisabled = !PassageTally.class.desiredAssertionStatus();
        log = Logger.getLogger((Class)PassageTally.class);
    }

    private static class TalliedVerseRange
    implements Comparable {
        protected VerseRange range;
        protected int tally;

        public TalliedVerseRange(VerseRange range, int tally) {
            this.range = range;
            this.tally = tally;
        }

        public int compareTo(Object obj) {
            TalliedVerseRange that = (TalliedVerseRange)obj;
            if (that.tally == this.tally) {
                return this.range.compareTo(that.range);
            }
            return that.tally - this.tally;
        }
    }

    private static final class OrderedVerseRangeIterator
    implements Iterator {
        private TalliedVerseRange last;
        private Iterator it;

        public OrderedVerseRangeIterator(Iterator vit, int[] board) {
            TreeSet<TalliedVerseRange> output = new TreeSet<TalliedVerseRange>();
            AbstractPassage.VerseRangeIterator rit = new AbstractPassage.VerseRangeIterator(vit, RestrictionType.NONE);
            while (rit.hasNext()) {
                VerseRange range = (VerseRange)rit.next();
                int rank = 0;
                Iterator vit2 = range.verseIterator();
                while (vit2.hasNext()) {
                    Verse verse = (Verse)vit2.next();
                    int temp = board[verse.getOrdinal() - 1];
                    if (temp <= rank) continue;
                    rank = temp;
                }
                output.add(new TalliedVerseRange(range, rank));
            }
            this.it = output.iterator();
        }

        public boolean hasNext() {
            return this.it.hasNext();
        }

        public Object next() throws NoSuchElementException {
            this.last = (TalliedVerseRange)this.it.next();
            return this.last.range;
        }

        public void remove() throws UnsupportedOperationException {
            throw new UnsupportedOperationException();
        }

        public int lastRank() throws NoSuchElementException {
            try {
                return this.last.tally;
            }
            catch (NullPointerException ex) {
                throw new NoSuchElementException(Msg.TALLY_ERROR_ENUM.toString());
            }
        }
    }

    private static class TalliedVerse
    implements Comparable {
        protected int ord;
        protected int tally;

        public TalliedVerse(int ord, int tally) {
            this.ord = ord;
            this.tally = tally;
        }

        public int compareTo(Object obj) {
            TalliedVerse that = (TalliedVerse)obj;
            if (that.tally == this.tally) {
                return this.ord - that.ord;
            }
            return that.tally - this.tally;
        }
    }

    private static final class OrderedVerseIterator
    implements Iterator {
        private TalliedVerse last;
        private Iterator it;
        static final /* synthetic */ boolean $assertionsDisabled;

        protected OrderedVerseIterator(int[] board) {
            TreeSet<TalliedVerse> output = new TreeSet<TalliedVerse>();
            int vib = BibleInfo.versesInBible();
            for (int i = 0; i < vib; ++i) {
                if (board[i] == 0) continue;
                output.add(new TalliedVerse(i + 1, board[i]));
            }
            this.it = output.iterator();
        }

        public boolean hasNext() {
            return this.it.hasNext();
        }

        public Object next() throws NoSuchElementException {
            try {
                this.last = (TalliedVerse)this.it.next();
                return new Verse(this.last.ord);
            }
            catch (NoSuchVerseException ex) {
                if (!$assertionsDisabled) {
                    throw new AssertionError((Object)ex);
                }
                return Verse.DEFAULT;
            }
        }

        public void remove() throws UnsupportedOperationException {
            throw new UnsupportedOperationException();
        }

        public int lastRank() throws NoSuchElementException {
            try {
                return this.last.tally;
            }
            catch (NullPointerException ex) {
                throw new NoSuchElementException(Msg.TALLY_ERROR_ENUM.toString());
            }
        }

        static {
            $assertionsDisabled = !(class$org$crosswire$jsword$passage$PassageTally == null ? (class$org$crosswire$jsword$passage$PassageTally = PassageTally.class$("org.crosswire.jsword.passage.PassageTally")) : class$org$crosswire$jsword$passage$PassageTally).desiredAssertionStatus();
        }
    }

    private final class VerseIterator
    implements Iterator {
        private int next;
        static final /* synthetic */ boolean $assertionsDisabled;

        public VerseIterator() {
            this.calculateNext();
        }

        public boolean hasNext() {
            return this.next <= BibleInfo.versesInBible();
        }

        public Object next() throws NoSuchElementException {
            try {
                if (this.next > BibleInfo.versesInBible()) {
                    throw new NoSuchElementException();
                }
                Verse retcode = new Verse(this.next);
                this.calculateNext();
                return retcode;
            }
            catch (NoSuchVerseException ex) {
                if (!$assertionsDisabled) {
                    throw new AssertionError((Object)ex);
                }
                return Verse.DEFAULT;
            }
        }

        public void remove() throws UnsupportedOperationException {
            throw new UnsupportedOperationException();
        }

        private void calculateNext() {
            do {
                ++this.next;
            } while (this.next <= BibleInfo.versesInBible() && PassageTally.this.board[this.next - 1] == 0);
        }

        static {
            $assertionsDisabled = !(class$org$crosswire$jsword$passage$PassageTally == null ? (class$org$crosswire$jsword$passage$PassageTally = PassageTally.class$("org.crosswire.jsword.passage.PassageTally")) : class$org$crosswire$jsword$passage$PassageTally).desiredAssertionStatus();
        }
    }
}

