/*
 * Decompiled with CFR 0.152.
 */
package org.crosswire.jsword.passage;

import java.util.Iterator;
import org.crosswire.common.util.Logger;
import org.crosswire.jsword.passage.Key;
import org.crosswire.jsword.passage.KeyFactory;
import org.crosswire.jsword.passage.KeyVisitor;
import org.crosswire.jsword.passage.NoSuchKeyException;
import org.crosswire.jsword.passage.NoSuchVerseException;
import org.crosswire.jsword.passage.Passage;
import org.crosswire.jsword.passage.PassageKeyFactory;
import org.crosswire.jsword.passage.Verse;
import org.crosswire.jsword.passage.VerseFactory;

public class KeyUtil {
    private static KeyFactory keyf = PassageKeyFactory.instance();
    private static final Logger log = Logger.getLogger((Class)KeyUtil.class);

    private KeyUtil() {
    }

    public static void visit(Key key, KeyVisitor visitor) {
        Iterator it = key.iterator();
        while (it.hasNext()) {
            Key subkey = (Key)it.next();
            if (subkey.canHaveChildren()) {
                visitor.visitBranch(subkey);
                KeyUtil.visit(subkey, visitor);
                continue;
            }
            visitor.visitLeaf(subkey);
        }
    }

    public static Verse getVerse(Key key) {
        if (key instanceof Verse) {
            return (Verse)key;
        }
        if (key instanceof Passage) {
            Passage ref = KeyUtil.getPassage(key);
            return ref.getVerseAt(0);
        }
        try {
            Verse verse = VerseFactory.fromString(key.getName());
            return verse;
        }
        catch (NoSuchVerseException ex) {
            log.warn("Key can't be a verse: " + key.getName());
            return Verse.DEFAULT;
        }
    }

    public static Passage getPassage(Key key) {
        if (key == null) {
            return null;
        }
        if (key instanceof Passage) {
            return (Passage)key;
        }
        Key ref = null;
        try {
            ref = keyf.getKey(key.getName());
        }
        catch (NoSuchKeyException ex) {
            log.warn("Key can't be a passage: " + key.getName());
            ref = keyf.createEmptyKeyList();
        }
        return (Passage)ref;
    }
}

