/*
 * Decompiled with CFR 0.152.
 */
package org.crosswire.jsword.passage;

import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.util.Collections;
import java.util.Iterator;
import java.util.SortedSet;
import java.util.TreeSet;
import org.crosswire.jsword.passage.AbstractPassage;
import org.crosswire.jsword.passage.NoSuchVerseException;
import org.crosswire.jsword.passage.Verse;
import org.crosswire.jsword.passage.VerseBase;

public class DistinctPassage
extends AbstractPassage {
    static final long serialVersionUID = 817374460730441662L;
    private transient SortedSet store = Collections.synchronizedSortedSet(new TreeSet());

    protected DistinctPassage() {
    }

    protected DistinctPassage(String refs) throws NoSuchVerseException {
        super(refs);
        this.store = Collections.synchronizedSortedSet(new TreeSet());
        this.addVerses(refs);
    }

    public Object clone() {
        DistinctPassage copy = (DistinctPassage)super.clone();
        copy.store = Collections.synchronizedSortedSet(new TreeSet());
        copy.store.addAll(this.store);
        return copy;
    }

    public Iterator iterator() {
        return this.store.iterator();
    }

    public boolean isEmpty() {
        return this.store.isEmpty();
    }

    public int countVerses() {
        return this.store.size();
    }

    public boolean contains(VerseBase obj) {
        Verse[] verses = DistinctPassage.toVerseArray(obj);
        for (int i = 0; i < verses.length; ++i) {
            if (this.store.contains(verses[i])) continue;
            return false;
        }
        return true;
    }

    public void add(VerseBase obj) {
        this.optimizeWrites();
        Verse[] verses = DistinctPassage.toVerseArray(obj);
        for (int i = 0; i < verses.length; ++i) {
            this.store.add(verses[i]);
        }
        if (this.suppressEvents == 0) {
            this.fireIntervalAdded(this, verses[0], verses[verses.length - 1]);
        }
    }

    public void remove(VerseBase obj) {
        this.optimizeWrites();
        Verse[] verses = DistinctPassage.toVerseArray(obj);
        for (int i = 0; i < verses.length; ++i) {
            this.store.remove(verses[i]);
        }
        if (this.suppressEvents == 0) {
            this.fireIntervalRemoved(this, verses[0], verses[verses.length - 1]);
        }
    }

    public void clear() {
        this.optimizeWrites();
        this.store.clear();
        this.fireIntervalRemoved(this, null, null);
    }

    private void writeObject(ObjectOutputStream out) throws IOException {
        this.writeObjectSupport(out);
    }

    private void readObject(ObjectInputStream in) throws IOException, ClassNotFoundException {
        this.optimizeWrites();
        this.store = Collections.synchronizedSortedSet(new TreeSet());
        this.readObjectSupport(in);
    }
}

