/*
 * Decompiled with CFR 0.152.
 */
package org.crosswire.jsword.passage;

import java.io.Serializable;
import java.util.StringTokenizer;
import org.crosswire.common.util.MsgBase;
import org.crosswire.jsword.passage.BibleInfo;
import org.crosswire.jsword.passage.Msg;
import org.crosswire.jsword.passage.NoSuchVerseException;
import org.crosswire.jsword.passage.Verse;
import org.crosswire.jsword.passage.VerseRange;

public abstract class AccuracyType
implements Serializable {
    public static final AccuracyType BOOK_VERSE;
    public static final AccuracyType BOOK_CHAPTER;
    public static final AccuracyType BOOK_ONLY;
    public static final AccuracyType CHAPTER_VERSE;
    public static final AccuracyType CHAPTER_ONLY;
    public static final AccuracyType VERSE_ONLY;
    public static final String VERSE_ALLOWED_DELIMS = " :.";
    private String name;
    private static int nextObj;
    private final int obj = nextObj++;
    private static final AccuracyType[] VALUES;
    public static final String VERSE_END_MARK1 = "$";
    public static final String VERSE_END_MARK2 = "ff";
    static final /* synthetic */ boolean $assertionsDisabled;

    public AccuracyType(String name) {
        this.name = name;
    }

    public abstract Verse createStartVerse(String var1, VerseRange var2, String[] var3) throws NoSuchVerseException;

    public abstract Verse createEndVerse(String var1, Verse var2, String[] var3) throws NoSuchVerseException;

    public boolean isBook() {
        return false;
    }

    public boolean isChapter() {
        return false;
    }

    public boolean isVerse() {
        return false;
    }

    public static final int getChapter(int lbook, String chapter) throws NoSuchVerseException {
        if (AccuracyType.isEndMarker(chapter)) {
            return BibleInfo.chaptersInBook(lbook);
        }
        return AccuracyType.parseInt(chapter);
    }

    public static final int getVerse(int lbook, int lchapter, String verse) throws NoSuchVerseException {
        if (AccuracyType.isEndMarker(verse)) {
            return BibleInfo.versesInChapter(lbook, lchapter);
        }
        return AccuracyType.parseInt(verse);
    }

    public int toInteger() {
        for (int i = 0; i < VALUES.length; ++i) {
            if (!this.equals(VALUES[i])) continue;
            return i;
        }
        if (!$assertionsDisabled) {
            throw new AssertionError();
        }
        return -1;
    }

    public static AccuracyType fromText(String[] parts) throws NoSuchVerseException {
        return AccuracyType.fromText(parts, null, null);
    }

    public static AccuracyType fromText(String[] parts, AccuracyType verseAccuracy) throws NoSuchVerseException {
        return AccuracyType.fromText(parts, verseAccuracy, null);
    }

    public static AccuracyType fromText(String[] parts, VerseRange basis) throws NoSuchVerseException {
        return AccuracyType.fromText(parts, null, basis);
    }

    public static AccuracyType fromText(String[] parts, AccuracyType verseAccuracy, VerseRange basis) throws NoSuchVerseException {
        switch (parts.length) {
            case 1: {
                if (BibleInfo.isBookName(parts[0])) {
                    return BOOK_ONLY;
                }
                AccuracyType.checkValidChapterOrVerse(parts[0]);
                if (verseAccuracy != null) {
                    if (verseAccuracy.isVerse()) {
                        return VERSE_ONLY;
                    }
                    if (verseAccuracy.isChapter()) {
                        return CHAPTER_ONLY;
                    }
                }
                if (basis != null) {
                    if (basis.isWholeChapter()) {
                        return CHAPTER_ONLY;
                    }
                    return VERSE_ONLY;
                }
                throw new NoSuchVerseException((MsgBase)Msg.VERSE_PARTS, new Object[]{VERSE_ALLOWED_DELIMS});
            }
            case 2: {
                int pbook = BibleInfo.getBookNumber(parts[0]);
                if (pbook == -1) {
                    AccuracyType.checkValidChapterOrVerse(parts[0]);
                    AccuracyType.checkValidChapterOrVerse(parts[1]);
                    return CHAPTER_VERSE;
                }
                if (BibleInfo.chaptersInBook(pbook) == 1) {
                    return BOOK_VERSE;
                }
                return BOOK_CHAPTER;
            }
            case 3: {
                if (BibleInfo.getBookNumber(parts[0]) != -1) {
                    AccuracyType.checkValidChapterOrVerse(parts[1]);
                    AccuracyType.checkValidChapterOrVerse(parts[2]);
                    return BOOK_VERSE;
                }
                throw new NoSuchVerseException((MsgBase)Msg.VERSE_PARTS, new Object[]{VERSE_ALLOWED_DELIMS});
            }
        }
        throw new NoSuchVerseException((MsgBase)Msg.VERSE_PARTS, new Object[]{VERSE_ALLOWED_DELIMS});
    }

    private static final void checkValidChapterOrVerse(String text) throws NoSuchVerseException {
        if (!AccuracyType.isEndMarker(text)) {
            AccuracyType.parseInt(text);
        }
    }

    private static int parseInt(String text) throws NoSuchVerseException {
        try {
            return Integer.parseInt(text);
        }
        catch (NumberFormatException ex) {
            throw new NoSuchVerseException((MsgBase)Msg.VERSE_PARSE, new Object[]{text});
        }
    }

    private static boolean isEndMarker(String text) {
        if (text.equals(VERSE_END_MARK1)) {
            return true;
        }
        return text.equals(VERSE_END_MARK2);
    }

    public static String[] tokenize(String command) {
        int i;
        String delim = VERSE_ALLOWED_DELIMS;
        StringTokenizer tokenize = new StringTokenizer(command, delim);
        String[] args = new String[tokenize.countTokens()];
        int argc = 0;
        while (tokenize.hasMoreTokens()) {
            args[argc++] = tokenize.nextToken();
        }
        if (args.length > 1 && Character.isLetter(args[1].charAt(0)) && !AccuracyType.isEndMarker(args[1])) {
            int roman = AccuracyType.isRoman(args[0]);
            if (roman != 0) {
                args[0] = Integer.toString(roman);
            }
            if (Character.isDigit(args[0].charAt(0))) {
                String[] oldargs = args;
                args = new String[oldargs.length - 1];
                args[0] = oldargs[0] + oldargs[1];
                for (i = 1; i < args.length; ++i) {
                    args[i] = oldargs[i + 1];
                }
            }
        }
        if (args.length > 0 && Character.isDigit(args[0].charAt(args[0].length() - 1)) && AccuracyType.containsLetter(args[0])) {
            String word = args[0];
            boolean foundLetters = false;
            i = 0;
            for (i = 0; i < word.length(); ++i) {
                if (!foundLetters) {
                    if (!Character.isLetter(word.charAt(i))) continue;
                    foundLetters = true;
                    continue;
                }
                if (!Character.isLetter(word.charAt(i))) break;
            }
            String[] oldargs = args;
            args = new String[oldargs.length + 1];
            args[0] = oldargs[0].substring(0, i);
            args[1] = oldargs[0].substring(i);
            for (int j = 2; j < args.length; ++j) {
                args[j] = oldargs[j - 1];
            }
        }
        return args;
    }

    private static int isRoman(String text) {
        if (text.matches("^[Ii]{1,3}$")) {
            return text.length();
        }
        return 0;
    }

    private static boolean containsLetter(String text) {
        for (int i = 0; i < text.length(); ++i) {
            if (!Character.isLetter(text.charAt(i))) continue;
            return true;
        }
        return false;
    }

    public static AccuracyType fromString(String name) {
        for (int i = 0; i < VALUES.length; ++i) {
            AccuracyType o = VALUES[i];
            if (!o.name.equalsIgnoreCase(name)) continue;
            return o;
        }
        if (!$assertionsDisabled) {
            throw new AssertionError();
        }
        return null;
    }

    public static AccuracyType fromInteger(int i) {
        return VALUES[i];
    }

    public final boolean equals(Object o) {
        return super.equals(o);
    }

    public final int hashCode() {
        return super.hashCode();
    }

    public String toString() {
        return this.name;
    }

    Object readResolve() {
        return VALUES[this.obj];
    }

    static {
        $assertionsDisabled = !AccuracyType.class.desiredAssertionStatus();
        BOOK_VERSE = new AccuracyType("BOOK_VERSE"){
            private static final long serialVersionUID = 3256719589483165495L;

            public boolean isVerse() {
                return true;
            }

            public Verse createStartVerse(String original, VerseRange verseRangeBasis, String[] parts) throws NoSuchVerseException {
                int book = BibleInfo.getBookNumber(parts[0]);
                int chapter = 1;
                int verse = 1;
                if (parts.length == 3) {
                    chapter = 1.getChapter(book, parts[1]);
                    verse = 1.getVerse(book, chapter, parts[2]);
                } else {
                    verse = 1.getVerse(book, chapter, parts[1]);
                }
                return new Verse(original, book, chapter, verse);
            }

            public Verse createEndVerse(String endVerseDesc, Verse verseBasis, String[] endParts) throws NoSuchVerseException {
                return this.createStartVerse(endVerseDesc, null, endParts);
            }
        };
        BOOK_CHAPTER = new AccuracyType("BOOK_CHAPTER"){
            private static final long serialVersionUID = 3258125864737911609L;

            public boolean isChapter() {
                return true;
            }

            public Verse createStartVerse(String original, VerseRange verseRangeBasis, String[] parts) throws NoSuchVerseException {
                int book = BibleInfo.getBookNumber(parts[0]);
                int chapter = 2.getChapter(book, parts[1]);
                int verse = 1;
                return new Verse(original, book, chapter, verse);
            }

            public Verse createEndVerse(String endVerseDesc, Verse verseBasis, String[] endParts) throws NoSuchVerseException {
                Verse end = this.createStartVerse(endVerseDesc, null, endParts);
                return end.getLastVerseInChapter();
            }
        };
        BOOK_ONLY = new AccuracyType("BOOK_ONLY"){
            private static final long serialVersionUID = 4050486707419821620L;

            public boolean isBook() {
                return true;
            }

            public Verse createStartVerse(String original, VerseRange verseRangeBasis, String[] parts) throws NoSuchVerseException {
                int book = BibleInfo.getBookNumber(parts[0]);
                return new Verse(original, book, 1, 1);
            }

            public Verse createEndVerse(String endVerseDesc, Verse verseBasis, String[] endParts) throws NoSuchVerseException {
                Verse end = this.createStartVerse(endVerseDesc, null, endParts);
                return end.getLastVerseInBook();
            }
        };
        CHAPTER_VERSE = new AccuracyType("CHAPTER_VERSE"){
            private static final long serialVersionUID = 3691040958808668471L;

            public boolean isVerse() {
                return true;
            }

            public Verse createStartVerse(String original, VerseRange verseRangeBasis, String[] parts) throws NoSuchVerseException {
                int book = verseRangeBasis.getEnd().getBook();
                int chapter = 4.getChapter(book, parts[0]);
                int verse = 4.getVerse(book, chapter, parts[1]);
                return new Verse(original, book, chapter, verse);
            }

            public Verse createEndVerse(String endVerseDesc, Verse verseBasis, String[] endParts) throws NoSuchVerseException {
                int book = verseBasis.getBook();
                int chapter = 4.getChapter(book, endParts[0]);
                int verse = 4.getVerse(book, chapter, endParts[1]);
                return new Verse(endVerseDesc, book, chapter, verse);
            }
        };
        CHAPTER_ONLY = new AccuracyType("CHAPTER_ONLY"){
            private static final long serialVersionUID = 3689918357520463409L;

            public boolean isChapter() {
                return true;
            }

            public Verse createStartVerse(String original, VerseRange verseRangeBasis, String[] parts) throws NoSuchVerseException {
                int book = verseRangeBasis.getEnd().getBook();
                int chapter = 5.getChapter(book, parts[0]);
                return new Verse(original, book, chapter, 1);
            }

            public Verse createEndVerse(String endVerseDesc, Verse verseBasis, String[] endParts) throws NoSuchVerseException {
                int book = verseBasis.getBook();
                int chapter = 5.getChapter(book, endParts[0]);
                Verse end = new Verse(endVerseDesc, book, chapter, 1);
                return end.getLastVerseInChapter();
            }
        };
        VERSE_ONLY = new AccuracyType("VERSE_ONLY"){
            private static final long serialVersionUID = 3691034361722320178L;

            public boolean isVerse() {
                return true;
            }

            public Verse createStartVerse(String original, VerseRange verseRangeBasis, String[] parts) throws NoSuchVerseException {
                int book = verseRangeBasis.getEnd().getBook();
                int chapter = verseRangeBasis.getEnd().getChapter();
                int verse = 6.getVerse(book, chapter, parts[0]);
                return new Verse(original, book, chapter, verse);
            }

            public Verse createEndVerse(String endVerseDesc, Verse verseBasis, String[] endParts) throws NoSuchVerseException {
                int book = verseBasis.getBook();
                int chapter = verseBasis.getChapter();
                int verse = 6.getVerse(book, chapter, endParts[0]);
                return new Verse(endVerseDesc, book, chapter, verse);
            }
        };
        VALUES = new AccuracyType[]{BOOK_CHAPTER, BOOK_VERSE, BOOK_ONLY, CHAPTER_VERSE, VERSE_ONLY};
    }
}

