/*
 * Decompiled with CFR 0.152.
 */
package org.crosswire.jsword.examples;

import java.util.List;
import javax.xml.transform.TransformerException;
import org.crosswire.common.xml.Converter;
import org.crosswire.common.xml.SAXEventProvider;
import org.crosswire.common.xml.XMLUtil;
import org.crosswire.jsword.book.Book;
import org.crosswire.jsword.book.BookData;
import org.crosswire.jsword.book.BookException;
import org.crosswire.jsword.book.BookFilter;
import org.crosswire.jsword.book.BookFilters;
import org.crosswire.jsword.book.Books;
import org.crosswire.jsword.book.BooksEvent;
import org.crosswire.jsword.book.BooksListener;
import org.crosswire.jsword.passage.Key;
import org.crosswire.jsword.passage.NoSuchKeyException;
import org.crosswire.jsword.util.ConverterFactory;
import org.xml.sax.SAXException;

public class APIExamples {
    private static final String BIBLE_NAME = "KJV";

    public void readPlainText() throws BookException, NoSuchKeyException {
        Books books = Books.installed();
        Book bible = books.getBook(BIBLE_NAME);
        Key key = bible.getKey("Gen 1 1");
        BookData data = bible.getData(key);
        String text = data.getPlainText();
        System.out.println("The plain text of Gen 1:1 is " + text);
    }

    public void readStyledText() throws NoSuchKeyException, BookException, TransformerException, SAXException {
        Book bible = Books.installed().getBook(BIBLE_NAME);
        Key key = bible.getKey("Gen 1 1");
        BookData data = bible.getData(key);
        SAXEventProvider osissep = data.getSAXEventProvider();
        Converter styler = ConverterFactory.getConverter();
        SAXEventProvider htmlsep = styler.convert(osissep);
        String text = XMLUtil.writeToString((SAXEventProvider)htmlsep);
        System.out.println("The html text of Gen 1:1 is " + text);
    }

    public void readDictionary() throws BookException {
        List dicts = Books.installed().getBooks(BookFilters.getDictionaries());
        Book dict = (Book)dicts.get(0);
        Key keys = dict.getGlobalKeyList();
        Key first = (Key)keys.iterator().next();
        System.out.println("The first Key in the default dictionary is " + first);
        BookData data = dict.getData(keys);
        System.out.println("And the text against that key is " + data.getPlainText());
    }

    public void search() throws BookException {
        Book bible = Books.installed().getBook(BIBLE_NAME);
        Key key = bible.find("moses + aaron");
        System.out.println("The following verses contain both moses and aaron: " + key.getName());
        key = bible.find("\"for god so loves the world\"");
        System.out.println("Trying to find verses like John 3:16: " + key.getName());
    }

    public void pickBible() {
        Book book = Books.installed().getBook(BIBLE_NAME);
        System.out.println(book.getLanguage());
        List books = Books.installed().getBooks();
        book = (Book)books.get(0);
        books = Books.installed().getBooks(BookFilters.getBibles());
        List test = Books.installed().getBooks(new BookFilter(){

            public boolean test(Book bk) {
                return bk.getName().equals("My Favorite Version");
            }
        });
        book = (Book)test.get(0);
        Books.installed().addBooksListener(new BooksListener(){

            public void bookAdded(BooksEvent ev) {
            }

            public void bookRemoved(BooksEvent ev) {
            }
        });
    }

    public static void main(String[] args) throws Exception {
        APIExamples examples = new APIExamples();
        examples.readPlainText();
        examples.readStyledText();
        examples.readDictionary();
        examples.search();
    }
}

