/*
 * Decompiled with CFR 0.152.
 */
package org.crosswire.jsword.book.sword;

import java.io.File;
import java.io.FileReader;
import java.io.IOException;
import java.io.Reader;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import org.crosswire.jsword.book.BookType;
import org.crosswire.jsword.book.FeatureType;
import org.crosswire.jsword.book.basic.AbstractBookMetaData;
import org.crosswire.jsword.book.filter.Filter;
import org.crosswire.jsword.book.filter.FilterFactory;
import org.crosswire.jsword.book.sword.ConfigEntryTable;
import org.crosswire.jsword.book.sword.ConfigEntryType;
import org.crosswire.jsword.book.sword.ModuleType;
import org.jdom.Document;

public class SwordBookMetaData
extends AbstractBookMetaData {
    static final Map ENCODING_JAVA = new HashMap();
    private ConfigEntryTable cet;

    public SwordBookMetaData(File file, String internal) throws IOException {
        this(new FileReader(file), internal);
    }

    public SwordBookMetaData(Reader in, String internal) throws IOException {
        this.cet = new ConfigEntryTable(in, internal);
        if (this.isSupported()) {
            this.buildProperties();
        }
    }

    public boolean isSupported() {
        return this.cet.isSupported();
    }

    public String getName() {
        return this.getProperty(ConfigEntryType.DESCRIPTION);
    }

    public String getModuleCharset() {
        return (String)ENCODING_JAVA.get(this.getProperty(ConfigEntryType.ENCODING));
    }

    public ModuleType getModuleType() {
        return this.cet.getModuleType();
    }

    public Filter getFilter() {
        String sourcetype = this.getProperty(ConfigEntryType.SOURCE_TYPE);
        return FilterFactory.getFilter(sourcetype);
    }

    public String getConfPath() {
        return "mods.d/" + this.getInitials().toLowerCase() + ".conf";
    }

    public String getModulePath() {
        String dataPath = this.getProperty(ConfigEntryType.DATA_PATH).substring(2);
        if (this.getType() == BookType.DICTIONARY || dataPath.charAt(dataPath.length() - 1) == '/') {
            dataPath = dataPath.substring(0, dataPath.lastIndexOf(47));
        }
        return dataPath;
    }

    public BookType getType() {
        return this.getModuleType().getBookType();
    }

    public Document toOSIS() {
        return new Document(this.cet.toOSIS());
    }

    public String getInitials() {
        return this.getProperty(ConfigEntryType.INITIALS);
    }

    public String getProperty(ConfigEntryType entry) {
        Object obj = this.cet.getValue(entry);
        return obj != null ? obj.toString() : null;
    }

    public boolean isLeftToRight() {
        String dir = this.getProperty(ConfigEntryType.DIRECTION);
        return dir == null || dir.equals(ConfigEntryType.DIRECTION.getDefault());
    }

    public boolean hasFeature(FeatureType feature) {
        return this.cet.match(ConfigEntryType.FEATURE, feature.toString());
    }

    private void buildProperties() {
        Iterator kit = this.cet.getKeys();
        while (kit.hasNext()) {
            ConfigEntryType key = (ConfigEntryType)kit.next();
            Object value = this.cet.getValue(key);
            if (value == null) continue;
            if (value instanceof List) {
                List list = (List)value;
                StringBuffer combined = new StringBuffer();
                boolean appendSeparator = false;
                Iterator vit = list.iterator();
                while (vit.hasNext()) {
                    String element = (String)vit.next();
                    if (appendSeparator) {
                        combined.append('\n');
                    }
                    combined.append(element);
                    appendSeparator = true;
                }
                value = combined.toString();
            }
            this.putProperty(key.toString(), value.toString());
        }
    }

    static {
        ENCODING_JAVA.put("Latin-1", "ISO-8859-1");
        ENCODING_JAVA.put("UTF-8", "UTF-8");
    }
}

