/*
 * Decompiled with CFR 0.152.
 */
package org.crosswire.jsword.book.search.parse;

import java.io.IOException;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import org.crosswire.common.util.Logger;
import org.crosswire.common.util.MsgBase;
import org.crosswire.common.util.ResourceUtil;
import org.crosswire.jsword.book.BookException;
import org.crosswire.jsword.book.search.Index;
import org.crosswire.jsword.book.search.Searcher;
import org.crosswire.jsword.book.search.parse.AddCommandWord;
import org.crosswire.jsword.book.search.parse.CommandWord;
import org.crosswire.jsword.book.search.parse.CustomTokenizer;
import org.crosswire.jsword.book.search.parse.Msg;
import org.crosswire.jsword.book.search.parse.ParamWord;
import org.crosswire.jsword.book.search.parse.Word;
import org.crosswire.jsword.passage.Key;

public class IndexSearcher
implements Searcher {
    private static final String PACKAGE_NAME = "org.crosswire.jsword.book.search.parse";
    private static final Logger log = Logger.getLogger((Class)IndexSearcher.class);
    private static Map wordMap;
    private static Map preferredMap;
    private Map commands;
    private Iterator wit;
    private Index index;

    public void init(Index newindex) {
        this.index = newindex;
        this.commands = IndexSearcher.getWordMap();
    }

    public Key search(String search) throws BookException {
        List output = CustomTokenizer.tokenize(search, this.commands);
        return this.search(output);
    }

    protected Key wordSearch(String sought) throws BookException {
        return this.index.findWord(sought);
    }

    protected Key search(List matches) throws BookException {
        Key key = this.index.findWord(null);
        if (matches.get(0) instanceof ParamWord) {
            matches.add(0, new AddCommandWord());
        }
        this.wit = matches.iterator();
        while (this.wit.hasNext()) {
            Object temp = this.wit.next();
            try {
                CommandWord command = (CommandWord)temp;
                command.updatePassage(this, key);
            }
            catch (ClassCastException ex) {
                ex.printStackTrace();
                throw new BookException((MsgBase)Msg.ENGINE_SYNTAX, new Object[]{temp});
            }
        }
        matches = null;
        this.wit = null;
        return key;
    }

    protected Key getPassage(String[] words) throws BookException {
        Key ref = this.index.findWord(null);
        for (int i = 0; i < words.length; ++i) {
            ref.addAll(this.wordSearch(words[i]));
        }
        return ref;
    }

    protected Index getIndex() {
        return this.index;
    }

    protected Map getSearchMap() {
        return this.commands;
    }

    protected void setSearchMap(Map commands) {
        this.commands = commands;
    }

    protected Iterator iterator() {
        return this.wit;
    }

    public Key iteratePassage() throws BookException {
        if (!this.iterator().hasNext()) {
            throw new BookException(Msg.RETAIN_BLANK);
        }
        Object next = this.iterator().next();
        if (!(next instanceof ParamWord)) {
            log.error("next=" + next);
        }
        ParamWord param = (ParamWord)next;
        Key ref = param.getKeyList(this);
        return ref;
    }

    public String iterateWord() throws BookException {
        if (!this.iterator().hasNext()) {
            throw new BookException(Msg.RETAIN_BLANK);
        }
        Object next = this.iterator().next();
        if (!(next instanceof ParamWord)) {
            log.error("next=" + next);
        }
        ParamWord param = (ParamWord)next;
        String word = param.getWord(this);
        return word;
    }

    public static Map getWordMap() {
        if (wordMap == null) {
            try {
                Properties prop = ResourceUtil.getProperties((Class)Word.class);
                wordMap = new HashMap();
                preferredMap = new HashMap();
                Iterator<Object> it = prop.keySet().iterator();
                while (it.hasNext()) {
                    Class<?> clazz;
                    String key = (String)it.next();
                    String value = prop.getProperty(key);
                    if (key.startsWith(PACKAGE_NAME)) {
                        try {
                            clazz = Class.forName(key);
                            preferredMap.put(clazz, value);
                        }
                        catch (Exception ex) {
                            log.error("can't add CommandWord: key=" + key + " Class=" + value, (Throwable)ex);
                        }
                        continue;
                    }
                    try {
                        clazz = Class.forName(value);
                        wordMap.put(key, clazz.newInstance());
                    }
                    catch (Exception ex) {
                        log.error("can't add CommandWord: key=" + key + " Class=" + value, (Throwable)ex);
                    }
                }
            }
            catch (IOException ex) {
                log.fatal("Missing search words", (Throwable)ex);
            }
        }
        return wordMap;
    }

    public static String getPreferredSyntax(Class command) {
        IndexSearcher.getWordMap();
        return (String)preferredMap.get(command);
    }
}

