/*
 * Decompiled with CFR 0.152.
 */
package org.crosswire.jsword.book.search;

import org.crosswire.common.util.StringUtil;

public class Grammar {
    private static final String[] ENDINGS = new String[]{"es", "'s", "s", "ing", "ed", "er", "ly"};
    private static final String[] WORD_FREQ = new String[]{"the", "and", "of", "to", "in", "he", "that", "i", "a", "for", "you", "his", "is", "will", "they", "not", "with", "him", "it", "be", "them", "shall", "all", "my", "from", "was", "your", "have", "me", "but", "their", "as", "who", "said", "are", "on", "this", "when", "thou", "thy", "by", "were", "had", "then", "out", "so", "there", "which", "do", "one", "ye", "up", "thee", "at", "we", "her", "what", "men", "come", "if", "into", "came", "upon", "before", "or", "us", "because", "go", "an", "went", "also", "now", "let", "hath", "may", "has", "our", "these", "o", "am"};

    private Grammar() {
    }

    public static String getRoot(String word) {
        for (int i = 0; i < ENDINGS.length; ++i) {
            if (!word.endsWith(ENDINGS[i])) continue;
            return word.substring(0, word.length() - ENDINGS[i].length());
        }
        return word;
    }

    public static boolean isSmallWord(String word) {
        if ((word = word.trim()).equals("")) {
            return true;
        }
        for (int i = 0; i < WORD_FREQ.length; ++i) {
            if (!word.equalsIgnoreCase(WORD_FREQ[i])) continue;
            return true;
        }
        return false;
    }

    public static String[] stripSmallWords(String[] words) {
        int long_words = 0;
        for (int i = 0; i < words.length; ++i) {
            if (Grammar.isSmallWord(words[i])) continue;
            ++long_words;
        }
        int count = 0;
        String[] retcode = new String[long_words];
        for (int i = 0; i < words.length; ++i) {
            if (Grammar.isSmallWord(words[i])) continue;
            retcode[count++] = words[i];
        }
        return retcode;
    }

    public static String[] tokenizeWithoutSmallWords(String original, String delims) {
        String[] words = StringUtil.split((String)original, (String)delims);
        int small_words = 0;
        for (int i = 0; i < words.length; ++i) {
            if (!Grammar.isSmallWord(words[i])) continue;
            ++small_words;
            words[i] = null;
        }
        String[] retcode = new String[words.length - small_words];
        int count = 0;
        for (int i = 0; i < words.length; ++i) {
            if (words[i] == null) continue;
            retcode[count++] = words[i];
        }
        return retcode;
    }
}

