/*
 * Decompiled with CFR 0.152.
 */
package org.crosswire.jsword.book.readings;

import java.text.DateFormat;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.Date;
import org.crosswire.jsword.book.readings.Msg;
import org.crosswire.jsword.passage.DefaultLeafKeyList;
import org.crosswire.jsword.passage.Key;
import org.crosswire.jsword.passage.NoSuchKeyException;

public class ReadingsKey
extends DefaultLeafKeyList {
    private Date date;
    private static final DateFormat NAME_DF = new SimpleDateFormat("d MMMM");
    private static final DateFormat OSIS_DF = new SimpleDateFormat("d.MMMM");

    protected ReadingsKey(String text, String osisName, Key parent) throws NoSuchKeyException {
        super(text, osisName, parent);
        try {
            this.date = NAME_DF.parse(text);
        }
        catch (ParseException ex) {
            throw new NoSuchKeyException(Msg.PARSE_FAIL, ex, new Object[]{text});
        }
    }

    protected ReadingsKey(Date date) {
        super(NAME_DF.format(date), OSIS_DF.format(date));
        this.date = date;
    }

    public boolean equals(Object obj) {
        if (obj == null) {
            return false;
        }
        if (!obj.getClass().equals(this.getClass())) {
            return false;
        }
        ReadingsKey that = (ReadingsKey)obj;
        return this.date.equals(that.date);
    }

    public int hashCode() {
        return this.date.hashCode();
    }

    public int compareTo(Object obj) {
        ReadingsKey that = (ReadingsKey)obj;
        return this.date.compareTo(that.date);
    }

    static {
        NAME_DF.setLenient(true);
    }
}

