/*
 * Decompiled with CFR 0.152.
 */
package org.crosswire.jsword.book.install.sword;

import java.io.IOException;
import java.io.OutputStream;
import java.net.MalformedURLException;
import java.net.URL;
import org.apache.commons.net.ftp.FTPClient;
import org.apache.commons.net.ftp.FTPReply;
import org.crosswire.common.progress.Job;
import org.crosswire.common.util.Logger;
import org.crosswire.common.util.MsgBase;
import org.crosswire.common.util.NetUtil;
import org.crosswire.jsword.book.Book;
import org.crosswire.jsword.book.BookMetaData;
import org.crosswire.jsword.book.install.InstallException;
import org.crosswire.jsword.book.install.sword.AbstractSwordInstaller;
import org.crosswire.jsword.book.install.sword.Msg;
import org.crosswire.jsword.book.sword.SwordBookMetaData;

public class FtpSwordInstaller
extends AbstractSwordInstaller
implements Comparable {
    private String username = "anonymous";
    private String password = "jsword@crosswire.com";
    private static final String PROTOCOL_SWORD = "sword-ftp";
    private static final Logger log;
    static final /* synthetic */ boolean $assertionsDisabled;

    public String getURL() {
        return "sword-ftp://" + this.username + ":" + this.password + "@" + this.host + this.directory;
    }

    public URL toRemoteURL(Book book) {
        BookMetaData bmd = book.getBookMetaData();
        if (!(bmd instanceof SwordBookMetaData)) {
            if (!$assertionsDisabled) {
                throw new AssertionError();
            }
            return null;
        }
        SwordBookMetaData sbmd = (SwordBookMetaData)bmd;
        try {
            return new URL("ftp", this.host, this.directory + "/" + sbmd.getInitials() + ".zip");
        }
        catch (MalformedURLException ex) {
            return null;
        }
    }

    protected void download(Job job, String dir, String file, URL dest) throws InstallException {
        FTPClient ftp = new FTPClient();
        try {
            log.info("Connecting to site=" + this.host + " dir=" + dir);
            ftp.connect(this.host);
            Thread.yield();
            log.info(ftp.getReplyString());
            int reply1 = ftp.getReplyCode();
            if (!FTPReply.isPositiveCompletion((int)reply1)) {
                String text1 = ftp.getReplyString();
                throw new InstallException((MsgBase)Msg.CONNECT_REFUSED, new Object[]{this.host, new Integer(reply1), text1});
            }
            ftp.login(this.username, this.password);
            Thread.yield();
            log.info(ftp.getReplyString());
            reply1 = ftp.getReplyCode();
            if (!FTPReply.isPositiveCompletion((int)reply1)) {
                String text2 = ftp.getReplyString();
                throw new InstallException((MsgBase)Msg.AUTH_REFUSED, new Object[]{this.username, new Integer(reply1), text2});
            }
            ftp.changeWorkingDirectory(dir);
            Thread.yield();
            log.info(ftp.getReplyString());
            reply1 = ftp.getReplyCode();
            if (!FTPReply.isPositiveCompletion((int)reply1)) {
                String text3 = ftp.getReplyString();
                throw new InstallException((MsgBase)Msg.CWD_REFUSED, new Object[]{dir, new Integer(reply1), text3});
            }
            ftp.setFileType(2);
            Thread.yield();
            URL parent = NetUtil.shortenURL((URL)dest, (String)"mods.d.tar.gz");
            NetUtil.makeDirectory((URL)parent);
            OutputStream out = NetUtil.getOutputStream((URL)dest);
            ftp.retrieveFile(file, out);
            int reply = ftp.getReplyCode();
            if (!FTPReply.isPositiveCompletion((int)reply)) {
                String text = ftp.getReplyString();
                throw new InstallException((MsgBase)Msg.DOWNLOAD_REFUSED, new Object[]{"mods.d.tar.gz", new Integer(reply), text});
            }
            out.close();
        }
        catch (IOException ex) {
            throw new InstallException((MsgBase)Msg.UNKNOWN_ERROR, ex);
        }
        finally {
            if (ftp.isConnected()) {
                try {
                    ftp.disconnect();
                }
                catch (IOException ex2) {
                    log.error("disconnect error", (Throwable)ex2);
                }
            }
        }
    }

    public String getPassword() {
        return this.password;
    }

    public void setPassword(String password) {
        this.password = password;
    }

    public String getUsername() {
        return this.username;
    }

    public void setUsername(String username) {
        this.username = username;
    }

    public String toString() {
        return this.getURL();
    }

    public boolean equals(Object object) {
        if (!(object instanceof FtpSwordInstaller)) {
            return false;
        }
        FtpSwordInstaller that = (FtpSwordInstaller)object;
        if (!super.equals(that)) {
            return false;
        }
        if (!this.equals(this.password, that.password)) {
            return false;
        }
        return this.equals(this.username, that.username);
    }

    public int hashCode() {
        return super.hashCode() + this.username.hashCode() + this.password.hashCode();
    }

    static {
        $assertionsDisabled = !FtpSwordInstaller.class.desiredAssertionStatus();
        log = Logger.getLogger((Class)FtpSwordInstaller.class);
    }
}

