/*
 * Decompiled with CFR 0.152.
 */
package org.crosswire.jsword.book.filter.gbf;

import java.util.LinkedList;
import org.crosswire.jsword.book.DataPolice;
import org.crosswire.jsword.book.OSISUtil;
import org.crosswire.jsword.book.filter.gbf.Tag;
import org.crosswire.jsword.book.filter.gbf.TagBuilder;
import org.jdom.Content;
import org.jdom.Element;
import org.jdom.Text;

public class StrongsWordTagBuilder
implements TagBuilder {
    public Tag createTag(final String tagname) {
        if (!tagname.startsWith("WH") && !tagname.startsWith("WG")) {
            return null;
        }
        return new Tag(){

            public void updateOsisStack(LinkedList stack) {
                String name = tagname.trim();
                Element ele = (Element)stack.get(0);
                int size = ele.getContentSize();
                if (size == 0) {
                    DataPolice.report("No content to attach word to: <" + name + ">.");
                    return;
                }
                int lastIndex = size - 1;
                Content prevObj = ele.getContent(lastIndex);
                Element word = null;
                if (prevObj instanceof Text) {
                    Text textItem = (Text)prevObj;
                    word = OSISUtil.factory().createW();
                    ele.removeContent((Content)textItem);
                    word.addContent((Content)textItem);
                    ele.addContent((Content)word);
                } else if (prevObj instanceof Element) {
                    word = (Element)prevObj;
                } else {
                    DataPolice.report("No words to attach word to: <" + name + ">.");
                    return;
                }
                String existingLemma = word.getAttributeValue("lemma");
                StringBuffer newLemma = new StringBuffer();
                if (existingLemma != null && existingLemma.length() > 0) {
                    newLemma.append(existingLemma).append('|');
                }
                newLemma.append("x-Strongs:").append(name.substring(2));
                word.setAttribute("lemma", newLemma.toString());
            }
        };
    }
}

