/*
 * Decompiled with CFR 0.152.
 */
package org.crosswire.jsword.book.basic;

import java.util.Collections;
import java.util.EventListener;
import java.util.Iterator;
import java.util.List;
import org.crosswire.common.util.CollectionUtil;
import org.crosswire.common.util.EventListenerList;
import org.crosswire.jsword.book.Book;
import org.crosswire.jsword.book.BookFilter;
import org.crosswire.jsword.book.BookFilterIterator;
import org.crosswire.jsword.book.BookList;
import org.crosswire.jsword.book.BooksEvent;
import org.crosswire.jsword.book.BooksListener;

public abstract class AbstractBookList
implements BookList {
    private static EventListenerList listeners = new EventListenerList();

    public List getBooks(BookFilter filter) {
        List temp = CollectionUtil.createList((Iterator)new BookFilterIterator(this.getBooks().iterator(), filter));
        return Collections.unmodifiableList(temp);
    }

    public synchronized void addBooksListener(BooksListener li) {
        listeners.add(BooksListener.class, (EventListener)li);
    }

    public synchronized void removeBooksListener(BooksListener li) {
        listeners.remove(BooksListener.class, (EventListener)li);
    }

    protected static synchronized void fireBooksChanged(Object source, Book book, boolean added) {
        Object[] contents = listeners.getListenerList();
        BooksEvent ev = null;
        for (int i = contents.length - 2; i >= 0; i -= 2) {
            if (contents[i] != (class$org$crosswire$jsword$book$BooksListener == null ? AbstractBookList.class$("org.crosswire.jsword.book.BooksListener") : class$org$crosswire$jsword$book$BooksListener)) continue;
            if (ev == null) {
                ev = new BooksEvent(source, book, added);
            }
            if (added) {
                ((BooksListener)contents[i + 1]).bookAdded(ev);
                continue;
            }
            ((BooksListener)contents[i + 1]).bookRemoved(ev);
        }
    }
}

