/*
 * Decompiled with CFR 0.152.
 */
package org.crosswire.jsword.book;

import java.util.Collection;
import java.util.HashMap;
import java.util.Iterator;
import org.crosswire.common.util.Logger;
import org.crosswire.jsword.book.Book;
import org.crosswire.jsword.book.BookData;
import org.crosswire.jsword.book.BookException;
import org.crosswire.jsword.book.OSISUtil;
import org.crosswire.jsword.book.Strongs;
import org.crosswire.jsword.book.Translation;
import org.crosswire.jsword.passage.Key;
import org.crosswire.jsword.passage.NoSuchKeyException;
import org.jdom.Element;

public class StudyTool {
    protected static final Logger log = Logger.getLogger((Class)StudyTool.class);

    public Collection getTranslations(Book bible, String word) throws BookException {
        Key key = bible.find(word);
        BookData data = bible.getData(key);
        HashMap<Strongs, Translation> reply = new HashMap<Strongs, Translation>();
        Iterator oit = data.getOsis().getChild("osisText").getChildren("div").iterator();
        while (oit.hasNext()) {
            Element div = (Element)oit.next();
            Iterator dit = OSISUtil.getDeepContent(div, "w").iterator();
            while (dit.hasNext()) {
                Object ele = dit.next();
                Element w = (Element)ele;
                String content = OSISUtil.getPlainText(w);
                if (content.indexOf(word) == -1) continue;
                Strongs strongs = new Strongs(w);
                Translation trans = (Translation)reply.get(strongs);
                if (trans == null) {
                    try {
                        trans = new Translation(word, strongs, bible.getKey(null));
                    }
                    catch (NoSuchKeyException ex) {
                        log.warn("Failed to create key", (Throwable)((Object)ex));
                    }
                    reply.put(strongs, trans);
                }
                trans.getKey().addAll(OSISUtil.getVerse(w));
            }
        }
        return reply.values();
    }

    public Collection getTranslations(Book bible, Strongs number) throws BookException {
        Key key = bible.find(number.getOLBName());
        BookData data = bible.getData(key);
        HashMap<String, Translation> reply = new HashMap<String, Translation>();
        Iterator oit = data.getOsis().getChild("osisText").getChildren("div").iterator();
        while (oit.hasNext()) {
            Element div = (Element)oit.next();
            Iterator dit = OSISUtil.getDeepContent(div, "w").iterator();
            while (dit.hasNext()) {
                Object ele = dit.next();
                Element w = (Element)ele;
                Strongs strongs = new Strongs(w);
                if (!strongs.equals(number)) continue;
                String translated = OSISUtil.getPlainText(w);
                Translation trans = (Translation)reply.get(translated);
                if (trans == null) {
                    try {
                        trans = new Translation(translated, number, bible.getKey(null));
                    }
                    catch (NoSuchKeyException ex) {
                        log.warn("Failed to create key", (Throwable)((Object)ex));
                    }
                    reply.put(translated, trans);
                }
                trans.getKey().addAll(OSISUtil.getVerse(w));
            }
        }
        return reply.values();
    }
}

