/*
 * Decompiled with CFR 0.152.
 */
package org.crosswire.jsword.book;

import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import org.crosswire.common.config.ChoiceFactory;
import org.crosswire.jsword.book.Book;
import org.crosswire.jsword.book.BookFilter;
import org.crosswire.jsword.book.BookFilters;
import org.crosswire.jsword.book.Books;
import org.crosswire.jsword.book.BooksEvent;
import org.crosswire.jsword.book.BooksListener;
import org.crosswire.jsword.book.DefaultBook;
import org.crosswire.jsword.book.readings.ReadingsBookDriver;

public class Defaults {
    private static final String BIBLE_KEY = "bible-names";
    private static final String COMMENTARY_KEY = "commentary-names";
    private static final String DICTIONARY_KEY = "dictionary-names";
    private static final String READINGS_KEY = "readings";
    private static final String GREEKDEF_KEY = "greekdef-names";
    private static final String HEBREWDEF_KEY = "hebrewdef-names";
    private static final String GREEKPARSE_KEY = "greekparse-names";
    private static final String HEBREWPARSE_KEY = "hebrewparse-names";
    private static DefaultBook bibleDeft;
    private static DefaultBook commentaryDeft;
    private static DefaultBook dictionaryDeft;
    private static DefaultBook greekParseDeft;
    private static DefaultBook hebrewParseDeft;
    private static DefaultBook greekDefinitionsDeft;
    private static DefaultBook hebrewDefinitionsDeft;
    static final /* synthetic */ boolean $assertionsDisabled;

    private Defaults() {
    }

    public static void setBible(Book book) {
        bibleDeft.setDefault(book);
    }

    protected static void unsetBible() {
        bibleDeft.unsetDefault();
    }

    public static Book getBible() {
        return bibleDeft.getDefault();
    }

    public static String getBibleByName() {
        return bibleDeft.getDefaultName();
    }

    public static void setBibleByName(String name) {
        bibleDeft.setDefaultByName(name);
    }

    public static void setCommentary(Book book) {
        commentaryDeft.setDefault(book);
    }

    protected static void unsetCommentary() {
        commentaryDeft.unsetDefault();
    }

    public static Book getCommentary() {
        return commentaryDeft.getDefault();
    }

    public static String getCommentaryByName() {
        return commentaryDeft.getDefaultName();
    }

    public static void setCommentaryByName(String name) {
        commentaryDeft.setDefaultByName(name);
    }

    public static void setDictionary(Book book) {
        dictionaryDeft.setDefault(book);
    }

    protected static void unsetDictionary() {
        dictionaryDeft.unsetDefault();
    }

    public static Book getDictionary() {
        return dictionaryDeft.getDefault();
    }

    public static String getDictionaryByName() {
        return dictionaryDeft.getDefaultName();
    }

    public static void setDictionaryByName(String name) {
        dictionaryDeft.setDefaultByName(name);
    }

    public static void setGreekDefinitions(Book book) {
        greekDefinitionsDeft.setDefault(book);
    }

    protected static void unsetGreekDefinitions() {
        greekDefinitionsDeft.unsetDefault();
    }

    public static Book getGreekDefinitions() {
        return greekDefinitionsDeft.getDefault();
    }

    public static String getGreekDefinitionsByName() {
        return greekDefinitionsDeft.getDefaultName();
    }

    public static void setGreekDefinitionsByName(String name) {
        greekDefinitionsDeft.setDefaultByName(name);
    }

    public static void setHebrewDefinitions(Book book) {
        hebrewDefinitionsDeft.setDefault(book);
    }

    protected static void unsetHebrewDefinitions() {
        hebrewDefinitionsDeft.unsetDefault();
    }

    public static Book getHebrewDefinitions() {
        return hebrewDefinitionsDeft.getDefault();
    }

    public static String getHebrewDefinitionsByName() {
        return hebrewDefinitionsDeft.getDefaultName();
    }

    public static void setHebrewDefinitionsByName(String name) {
        hebrewDefinitionsDeft.setDefaultByName(name);
    }

    public static void setGreekParse(Book book) {
        greekParseDeft.setDefault(book);
    }

    protected static void unsetGreekParse() {
        greekParseDeft.unsetDefault();
    }

    public static Book getGreekParse() {
        return greekParseDeft.getDefault();
    }

    public static String getGreekParseByName() {
        return greekParseDeft.getDefaultName();
    }

    public static void setGreekParseByName(String name) {
        greekParseDeft.setDefaultByName(name);
    }

    public static void setHebrewParse(Book book) {
        hebrewParseDeft.setDefault(book);
    }

    protected static void unsetHebrewParse() {
        hebrewParseDeft.unsetDefault();
    }

    public static Book getHebrewParse() {
        return hebrewParseDeft.getDefault();
    }

    public static String getHebrewParseByName() {
        return hebrewParseDeft.getDefaultName();
    }

    public static void setHebrewParseByName(String name) {
        hebrewParseDeft.setDefaultByName(name);
    }

    protected static DefaultBook getDefaultBible() {
        return bibleDeft;
    }

    protected static DefaultBook getDefaultCommentary() {
        return commentaryDeft;
    }

    protected static DefaultBook getDefaultDictionary() {
        return dictionaryDeft;
    }

    protected static DefaultBook getDefaultGreekDefinitions() {
        return greekDefinitionsDeft;
    }

    protected static DefaultBook getDefaultHebrewDefinitions() {
        return hebrewDefinitionsDeft;
    }

    protected static DefaultBook getDefaultGreekParse() {
        return greekParseDeft;
    }

    protected static DefaultBook getDefaultHebrewParse() {
        return hebrewParseDeft;
    }

    public static void refreshBooks() {
        String[] bnames = Defaults.getFullNameArray(BookFilters.getBibles());
        ChoiceFactory.getDataMap().put(BIBLE_KEY, bnames);
        String[] cnames = Defaults.getFullNameArray(BookFilters.getCommentaries());
        ChoiceFactory.getDataMap().put(COMMENTARY_KEY, cnames);
        String[] dnames = Defaults.getFullNameArray(BookFilters.getDictionaries());
        ChoiceFactory.getDataMap().put(DICTIONARY_KEY, dnames);
        String[] greekDef = Defaults.getFullNameArray(BookFilters.getGreekDefinitions());
        ChoiceFactory.getDataMap().put(GREEKDEF_KEY, greekDef);
        String[] hebrewDef = Defaults.getFullNameArray(BookFilters.getHebrewDefinitions());
        ChoiceFactory.getDataMap().put(HEBREWDEF_KEY, hebrewDef);
        String[] greekParse = Defaults.getFullNameArray(BookFilters.getGreekParse());
        ChoiceFactory.getDataMap().put(GREEKPARSE_KEY, greekParse);
        String[] hebrewParse = Defaults.getFullNameArray(BookFilters.getHebrewParse());
        ChoiceFactory.getDataMap().put(HEBREWPARSE_KEY, hebrewParse);
        ChoiceFactory.getDataMap().put(READINGS_KEY, ReadingsBookDriver.getInstalledReadingsSets());
    }

    protected static void checkAllPreferable() {
        List bmds = Books.installed().getBooks();
        Iterator it = bmds.iterator();
        while (it.hasNext()) {
            Book book = (Book)it.next();
            Defaults.checkPreferable(book);
        }
    }

    protected static void checkPreferable(Book book) {
        if (!$assertionsDisabled && book == null) {
            throw new AssertionError();
        }
        bibleDeft.setDefaultConditionally(book);
        commentaryDeft.setDefaultConditionally(book);
        dictionaryDeft.setDefaultConditionally(book);
        greekDefinitionsDeft.setDefaultConditionally(book);
        greekParseDeft.setDefaultConditionally(book);
        hebrewDefinitionsDeft.setDefaultConditionally(book);
        hebrewParseDeft.setDefaultConditionally(book);
    }

    private static String[] getFullNameArray(BookFilter filter) {
        List books = Books.installed().getBooks(filter);
        ArrayList<String> names = new ArrayList<String>();
        Iterator it = books.iterator();
        while (it.hasNext()) {
            Book book = (Book)it.next();
            names.add(book.getFullName());
        }
        return names.toArray(new String[names.size()]);
    }

    static {
        $assertionsDisabled = !Defaults.class.desiredAssertionStatus();
        bibleDeft = new DefaultBook(Books.installed(), BookFilters.getBibles());
        commentaryDeft = new DefaultBook(Books.installed(), BookFilters.getCommentaries());
        dictionaryDeft = new DefaultBook(Books.installed(), BookFilters.getDictionaries());
        greekParseDeft = new DefaultBook(Books.installed(), BookFilters.getGreekParse());
        hebrewParseDeft = new DefaultBook(Books.installed(), BookFilters.getHebrewParse());
        greekDefinitionsDeft = new DefaultBook(Books.installed(), BookFilters.getGreekDefinitions());
        hebrewDefinitionsDeft = new DefaultBook(Books.installed(), BookFilters.getHebrewDefinitions());
        Books.installed().addBooksListener(new DefaultsBookListener());
        Defaults.checkAllPreferable();
    }

    private static class DefaultsBookListener
    implements BooksListener {
        private DefaultsBookListener() {
        }

        public void bookAdded(BooksEvent ev) {
            Book book = ev.getBook();
            Defaults.checkPreferable(book);
            Defaults.refreshBooks();
        }

        public void bookRemoved(BooksEvent ev) {
            Book book = ev.getBook();
            Defaults.getDefaultBible().unsetDefaultConditionally(book);
            Defaults.getDefaultCommentary().unsetDefaultConditionally(book);
            Defaults.getDefaultDictionary().unsetDefaultConditionally(book);
            Defaults.getDefaultGreekDefinitions().unsetDefaultConditionally(book);
            Defaults.getDefaultGreekParse().unsetDefaultConditionally(book);
            Defaults.getDefaultHebrewDefinitions().unsetDefaultConditionally(book);
            Defaults.getDefaultHebrewParse().unsetDefaultConditionally(book);
        }
    }
}

