/*
 * Decompiled with CFR 0.152.
 */
package org.crosswire.jsword.book;

import java.util.Collection;
import java.util.Iterator;
import java.util.Set;
import java.util.TreeSet;
import org.crosswire.common.util.Filter;
import org.crosswire.common.util.SortedListSet;
import org.crosswire.jsword.book.BookMetaData;
import org.crosswire.jsword.book.Msg;

public class BookMetaDataSet
extends SortedListSet {
    private static final long serialVersionUID = 3258688806185154867L;

    public BookMetaDataSet() {
    }

    public BookMetaDataSet(Collection bmds) {
        super(bmds);
    }

    public Set getGroups() {
        TreeSet results = new TreeSet();
        Iterator bmdIter = this.iterator();
        while (bmdIter.hasNext()) {
            BookMetaData bmd = (BookMetaData)bmdIter.next();
            results.addAll(bmd.getProperties().keySet());
        }
        return results;
    }

    public Set getGroup(String key) {
        TreeSet<String> results = new TreeSet<String>();
        Iterator bmdIter = this.iterator();
        while (bmdIter.hasNext()) {
            BookMetaData bmd = (BookMetaData)bmdIter.next();
            Object property = bmd.getProperties().get(key);
            String propertyValue = property == null ? Msg.BOOK_METADATA_SET_OTHER.toString() : property.toString();
            results.add(propertyValue);
        }
        return results;
    }

    public BookMetaDataSet filter(String key, String value) {
        return (BookMetaDataSet)this.filter(new GroupFilter(key, value));
    }

    private static final class GroupFilter
    implements Filter {
        private String key;
        private String value;

        public GroupFilter(String aKey, String aValue) {
            this.key = aKey;
            this.value = aValue;
        }

        public boolean test(Object obj) {
            BookMetaData bmd = (BookMetaData)obj;
            return bmd.getProperties().get(this.key) == this.value;
        }
    }
}

