/*
 * Decompiled with CFR 0.152.
 */
package org.crosswire.bibledesktop.passage;

import java.util.Iterator;
import javax.swing.JList;
import javax.swing.JTree;
import javax.swing.tree.TreePath;
import org.crosswire.bibledesktop.passage.KeyTreeModel;
import org.crosswire.bibledesktop.passage.KeyTreeNode;
import org.crosswire.bibledesktop.passage.PassageListModel;
import org.crosswire.jsword.passage.DefaultKeyList;
import org.crosswire.jsword.passage.Key;
import org.crosswire.jsword.passage.Passage;
import org.crosswire.jsword.passage.VerseBase;
import org.crosswire.jsword.passage.VerseRange;

public class PassageGuiUtil {
    private PassageGuiUtil() {
    }

    public static void deleteSelectedVersesFromList(JList list) {
        PassageListModel plm = (PassageListModel)list.getModel();
        Passage ref = plm.getPassage();
        Object[] selected = list.getSelectedValues();
        for (int i = 0; i < selected.length; ++i) {
            VerseRange range = (VerseRange)selected[i];
            ref.remove((VerseBase)range);
        }
        list.setSelectedIndices(new int[0]);
    }

    public static void deleteSelectedVersesFromTree(JTree tree) {
        Key selected = PassageGuiUtil.getSelectedKeys(tree);
        KeyTreeModel mdl = (KeyTreeModel)tree.getModel();
        Key root = mdl.getKey();
        Iterator it = selected.iterator();
        while (it.hasNext()) {
            Key key = (Key)it.next();
            root.removeAll(key);
        }
        mdl.setKey(root);
    }

    public static Key getSelectedKeys(JTree tree) {
        DefaultKeyList selected = new DefaultKeyList();
        TreePath[] paths = tree.getSelectionPaths();
        for (int i = 0; i < paths.length; ++i) {
            KeyTreeNode node = (KeyTreeNode)paths[1].getLastPathComponent();
            selected.addAll(node.getKey());
        }
        return selected;
    }
}

