/*
 * Decompiled with CFR 0.152.
 */
package org.crosswire.bibledesktop.passage;

import java.util.Enumeration;
import javax.swing.tree.TreeNode;
import org.crosswire.common.util.IteratorEnumeration;
import org.crosswire.jsword.passage.Key;

public class KeyTreeNode
implements TreeNode {
    private Key key;
    private TreeNode parent;

    public KeyTreeNode(Key key, TreeNode parent) {
        this.key = key;
        this.parent = parent;
    }

    public int getChildCount() {
        return this.key.getChildCount();
    }

    public boolean getAllowsChildren() {
        return this.key.canHaveChildren();
    }

    public boolean isLeaf() {
        return this.key.isEmpty();
    }

    public Enumeration children() {
        return new IteratorEnumeration(this.key.iterator());
    }

    public TreeNode getParent() {
        return this.parent;
    }

    public TreeNode getChildAt(int index) {
        Key child = this.key.get(index);
        return new KeyTreeNode(child, this);
    }

    public int getIndex(TreeNode node) {
        if (node instanceof KeyTreeNode) {
            KeyTreeNode keynode = (KeyTreeNode)node;
            Key that = keynode.getKey();
            return this.key.indexOf(that);
        }
        return -1;
    }

    public Key getKey() {
        return this.key;
    }
}

