/*
 * Decompiled with CFR 0.152.
 */
package org.crosswire.bibledesktop.book.install;

import java.awt.Component;
import javax.swing.JTextPane;
import javax.swing.text.html.HTMLEditorKit;
import org.crosswire.common.swing.AntiAliasedTextPane;
import org.crosswire.common.util.Logger;
import org.crosswire.common.util.Reporter;
import org.crosswire.common.xml.Converter;
import org.crosswire.common.xml.JDOMSAXEventProvider;
import org.crosswire.common.xml.SAXEventProvider;
import org.crosswire.common.xml.TransformingSAXEventProvider;
import org.crosswire.common.xml.XMLUtil;
import org.crosswire.jsword.book.Book;
import org.crosswire.jsword.util.ConverterFactory;

public class TextPaneBookMetaDataDisplay {
    protected static final Logger log = Logger.getLogger((Class)TextPaneBookMetaDataDisplay.class);
    private Converter converter = ConverterFactory.getConverter();
    private JTextPane txtView = new AntiAliasedTextPane();

    public TextPaneBookMetaDataDisplay() {
        this.txtView.setEditable(false);
        this.txtView.setEditorKit(new HTMLEditorKit());
    }

    public void setBook(Book book) {
        if (book == null) {
            this.txtView.setText("");
            return;
        }
        try {
            JDOMSAXEventProvider osissep = new JDOMSAXEventProvider(book.toOSIS());
            TransformingSAXEventProvider htmlsep = (TransformingSAXEventProvider)this.converter.convert((SAXEventProvider)osissep);
            String text = XMLUtil.writeToString((SAXEventProvider)htmlsep);
            this.txtView.setText(text);
            this.txtView.select(0, 0);
        }
        catch (Exception ex) {
            Reporter.informUser((Object)this, (Throwable)ex);
        }
    }

    public Component getComponent() {
        return this.txtView;
    }
}

