/*
 * Decompiled with CFR 0.152.
 */
package org.crosswire.bibledesktop.book;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.FlowLayout;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.util.Iterator;
import java.util.Map;
import javax.swing.BorderFactory;
import javax.swing.JButton;
import javax.swing.JDialog;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JTabbedPane;
import org.crosswire.bibledesktop.book.EditSitePane;
import org.crosswire.bibledesktop.book.Msg;
import org.crosswire.bibledesktop.book.SitePane;
import org.crosswire.common.progress.swing.JobsProgressBar;
import org.crosswire.common.swing.ActionFactory;
import org.crosswire.jsword.book.install.InstallManager;
import org.crosswire.jsword.book.install.Installer;
import org.crosswire.jsword.book.install.InstallerEvent;
import org.crosswire.jsword.book.install.InstallerListener;

public class SitesPane
extends JPanel {
    private static final String CLOSE = "SitesClose";
    private static final String EDIT_SITE = "ManageSites";
    private Map installers;
    protected InstallManager imanager;
    private ActionFactory actions;
    private JDialog dlgMain;
    private JPanel pnlButtons;
    protected JTabbedPane tabMain;
    private static final long serialVersionUID = 3258126947069605936L;

    public SitesPane() {
        this.init();
        this.imanager = new InstallManager();
        this.installers = this.imanager.getInstallers();
        this.addAllInstallers();
        this.imanager.addInstallerListener(new InstallerListener(){

            public void installerAdded(InstallerEvent ev) {
                Installer installer = ev.getInstaller();
                String name = SitesPane.this.imanager.getInstallerNameForInstaller(installer);
                SitePane site = new SitePane(installer);
                SitesPane.this.tabMain.add(name, site);
            }

            public void installerRemoved(InstallerEvent ev) {
                SitesPane.this.removeAllInstallers();
                SitesPane.this.addAllInstallers();
            }
        });
    }

    private void init() {
        this.actions = new ActionFactory(SitesPane.class, (Object)this);
        this.tabMain = new JTabbedPane();
        this.setLayout(new BorderLayout());
        this.setBorder(BorderFactory.createEmptyBorder(5, 5, 5, 5));
        this.add((Component)this.tabMain, "Center");
        this.add((Component)new JobsProgressBar(true), "South");
    }

    protected final void addAllInstallers() {
        Iterator it = this.installers.keySet().iterator();
        while (it.hasNext()) {
            String name = (String)it.next();
            Installer installer = (Installer)this.installers.get(name);
            SitePane site = new SitePane(installer);
            this.tabMain.add(name, site);
        }
        this.tabMain.add(Msg.LOCAL_BOOKS.toString(), new SitePane());
    }

    protected void removeAllInstallers() {
        this.tabMain.removeAll();
    }

    public void doManageSites() {
        EditSitePane edit = new EditSitePane(this.imanager);
        edit.showInDialog(this);
    }

    public void doSitesClose() {
        if (this.dlgMain != null) {
            this.dlgMain.setVisible(false);
        }
    }

    public void showInDialog(Component parent) {
        this.dlgMain = new JDialog(JOptionPane.getFrameForComponent(parent));
        this.dlgMain.setSize(new Dimension(750, 500));
        this.dlgMain.getContentPane().setLayout(new BorderLayout());
        this.dlgMain.getContentPane().add((Component)this, "Center");
        this.dlgMain.getContentPane().add(this.createButtons(), "South");
        this.dlgMain.setTitle(Msg.AVAILABLE_BOOKS.toString());
        this.dlgMain.setModal(true);
        this.dlgMain.addWindowListener(new WindowAdapter(){

            public void windowClosed(WindowEvent ev) {
                SitesPane.this.doSitesClose();
            }
        });
        this.dlgMain.setLocationRelativeTo(parent);
        this.dlgMain.setVisible(true);
    }

    private Component createButtons() {
        if (this.pnlButtons == null) {
            JButton btnOK = new JButton(this.actions.getAction(CLOSE));
            JButton btnAdd = new JButton(this.actions.getAction(EDIT_SITE));
            this.pnlButtons = new JPanel();
            this.pnlButtons.setLayout(new FlowLayout(2));
            this.pnlButtons.add((Component)btnAdd, null);
            this.pnlButtons.add(btnOK);
        }
        return this.pnlButtons;
    }
}

