/*
 * Decompiled with CFR 0.152.
 */
package org.crosswire.bibledesktop.book;

import java.awt.BorderLayout;
import java.awt.Component;
import java.net.URL;
import java.util.Collection;
import javax.swing.BorderFactory;
import javax.swing.JButton;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTable;
import javax.swing.JTree;
import javax.swing.event.TreeSelectionEvent;
import javax.swing.event.TreeSelectionListener;
import javax.swing.table.TableModel;
import javax.swing.tree.DefaultMutableTreeNode;
import javax.swing.tree.DefaultTreeModel;
import javax.swing.tree.TreeModel;
import javax.swing.tree.TreePath;
import org.crosswire.bibledesktop.book.BookMetaDataTableModel;
import org.crosswire.bibledesktop.book.BookNode;
import org.crosswire.bibledesktop.book.Msg;
import org.crosswire.common.swing.ActionFactory;
import org.crosswire.common.swing.FixedSplitPane;
import org.crosswire.common.swing.MapTable;
import org.crosswire.common.swing.MapTableModel;
import org.crosswire.common.util.LucidException;
import org.crosswire.common.util.MsgBase;
import org.crosswire.common.util.NetUtil;
import org.crosswire.common.util.Reporter;
import org.crosswire.jsword.book.BookList;
import org.crosswire.jsword.book.BookMetaData;
import org.crosswire.jsword.book.BookMetaDataSet;
import org.crosswire.jsword.book.Books;
import org.crosswire.jsword.book.BooksEvent;
import org.crosswire.jsword.book.BooksListener;
import org.crosswire.jsword.book.install.InstallException;
import org.crosswire.jsword.book.install.Installer;
import org.crosswire.jsword.util.IndexDownloader;

public class SitePane
extends JPanel {
    private static final String INSTALLED_BOOKS_LABEL = "InstalledBooksLabel";
    private static final String AVAILABLE_BOOKS_LABEL = "AvailableBooksLabel";
    private static final String SELECTED_BOOK_LABEL = "SelectedBookLabel";
    private static final String REFRESH = "Refresh";
    private static final String INSTALL = "Install";
    private static final String INSTALL_SEARCH = "InstallSearch";
    protected Installer installer;
    private ActionFactory actions;
    private JTree treAvailable = null;
    private JTable tblSelected = null;
    private MapTableModel emptyTableModel = null;
    private JLabel lblDesc = null;
    private static final long serialVersionUID = 3616445692051075634L;

    public SitePane() {
        this(null, INSTALLED_BOOKS_LABEL);
    }

    public SitePane(Installer bookListInstaller) {
        this(bookListInstaller, AVAILABLE_BOOKS_LABEL);
    }

    private SitePane(Installer bookListInstaller, String labelAcronymn) {
        this.installer = bookListInstaller;
        this.actions = new ActionFactory(SitePane.class, (Object)this);
        Installer bl = this.installer;
        if (bl == null) {
            bl = Books.installed();
            bl.addBooksListener((BooksListener)new CustomBooksListener());
        }
        this.initialize(labelAcronymn, (BookList)bl);
    }

    private void initialize(String labelAcronymn, BookList books) {
        this.lblDesc = new JLabel();
        this.lblDesc.setBorder(BorderFactory.createEmptyBorder(5, 5, 0, 0));
        Component left = this.createAvailablePanel(labelAcronymn, books);
        Component right = this.createSelectedPanel();
        this.setLayout(new BorderLayout());
        this.add((Component)this.lblDesc, "North");
        this.add(this.createSplitPane(left, right), "Center");
        this.updateDescription();
    }

    private void updateDescription() {
        String desc = "#ERROR#";
        if (this.installer == null) {
            int bookCount = Books.installed().getBookMetaDatas().size();
            desc = Msg.INSTALLED_DESC.toString(new Object[]{new Integer(bookCount)});
        } else {
            int bookCount = this.installer.getBookMetaDatas().size();
            desc = bookCount == 0 ? Msg.NONE_AVAILABLE_DESC.toString() : Msg.AVAILABLE_DESC.toString(new Object[]{new Integer(bookCount)});
        }
        this.lblDesc.setText(desc);
    }

    private Component createSplitPane(Component left, Component right) {
        FixedSplitPane split = new FixedSplitPane();
        split.setDividerLocation(0.3);
        split.setResizeWeight(0.3);
        split.setOrientation(1);
        split.setBorder(BorderFactory.createEmptyBorder(5, 5, 5, 5));
        split.setDividerSize(10);
        split.setLeftComponent(left);
        split.setRightComponent(right);
        return split;
    }

    private Component createAvailablePanel(String labelAcronymn, BookList books) {
        JLabel lblAvailable = this.actions.createJLabel(labelAcronymn);
        JPanel panel = new JPanel();
        panel.setLayout(new BorderLayout());
        panel.add((Component)lblAvailable, "First");
        panel.add(this.createScrolledTree(books), "Center");
        panel.add(this.createPanelActions(), "Last");
        lblAvailable.setLabelFor(this.treAvailable);
        return panel;
    }

    private Component createSelectedPanel() {
        this.emptyTableModel = new MapTableModel(null);
        this.tblSelected = new MapTable(this.emptyTableModel);
        JLabel lblSelected = this.actions.createJLabel(SELECTED_BOOK_LABEL);
        lblSelected.setLabelFor(this.tblSelected);
        JScrollPane scrSelected = new JScrollPane();
        JPanel panel = new JPanel();
        panel.setLayout(new BorderLayout());
        panel.add((Component)lblSelected, "First");
        panel.add((Component)scrSelected, "Center");
        scrSelected.getViewport().add(this.tblSelected);
        return panel;
    }

    private Component createScrolledTree(BookList books) {
        this.treAvailable = new JTree();
        this.setTreeModel(books);
        this.treAvailable.putClientProperty("JTree.lineStyle", "Angled");
        this.treAvailable.getSelectionModel().setSelectionMode(1);
        this.treAvailable.setCellEditor(null);
        this.treAvailable.setRootVisible(false);
        this.treAvailable.setShowsRootHandles(true);
        this.treAvailable.addTreeSelectionListener(new TreeSelectionListener(){

            public void valueChanged(TreeSelectionEvent ev) {
                SitePane.this.selected();
            }
        });
        JScrollPane scroller = new JScrollPane();
        scroller.getViewport().add(this.treAvailable);
        return scroller;
    }

    private TreeModel createTreeModel(BookList books) {
        BookMetaDataSet bmds = new BookMetaDataSet((Collection)books.getBookMetaDatas());
        BookNode bookRoot = new BookNode("root", bmds, new Object[]{"Key", "Language"}, 0);
        return new DefaultTreeModel(bookRoot);
    }

    private BookMetaData getBookMetaData(Object obj) {
        if (obj instanceof DefaultMutableTreeNode) {
            obj = ((DefaultMutableTreeNode)obj).getUserObject();
        }
        if (obj instanceof BookMetaData) {
            return (BookMetaData)obj;
        }
        return null;
    }

    private Component createPanelActions() {
        JPanel panel = new JPanel();
        if (this.installer != null) {
            panel.add(new JButton(this.actions.getAction(INSTALL)));
            panel.add(new JButton(this.actions.getAction(INSTALL_SEARCH)));
            panel.add(new JButton(this.actions.getAction(REFRESH)));
        }
        return panel;
    }

    public void doDelete() {
    }

    public void doRefresh() {
        if (this.installer != null) {
            try {
                this.installer.reloadBookList();
                this.setTreeModel((BookList)this.installer);
            }
            catch (InstallException ex) {
                Reporter.informUser((Object)this, (LucidException)ex);
            }
        }
    }

    public void doInstall() {
        TreePath path;
        if (this.installer != null && (path = this.treAvailable.getSelectionPath()) != null) {
            Object last = path.getLastPathComponent();
            BookMetaData name = this.getBookMetaData(last);
            try {
                BookMetaData bmd = Books.installed().getBookMetaData(name.getName());
                if (bmd != null && !this.installer.isNewer(bmd)) {
                    Reporter.informUser((Object)this, (MsgBase)Msg.INSTALLED, (Object)name.getName());
                    return;
                }
                float size = (float)NetUtil.getSize((URL)this.installer.toRemoteURL(name)) / 1024.0f;
                if (JOptionPane.showConfirmDialog(this, Msg.SIZE.toString(new Object[]{name.getName(), new Float(size)}), Msg.CONFIRMATION_TITLE.toString(), 0) == 0) {
                    this.installer.install(name);
                }
            }
            catch (InstallException ex) {
                Reporter.informUser((Object)this, (LucidException)ex);
            }
        }
    }

    public void doInstallSearch() {
        this.doInstall();
        TreePath path = this.treAvailable.getSelectionPath();
        if (path != null) {
            try {
                Object last = path.getLastPathComponent();
                BookMetaData bmd = this.getBookMetaData(last);
                IndexDownloader.downloadIndex((BookMetaData)bmd, (Installer)this.installer);
            }
            catch (Exception ex) {
                Reporter.informUser((Object)this, (Throwable)ex);
            }
        }
    }

    protected void selected() {
        Object last;
        BookMetaData bmd;
        TreePath path = this.treAvailable.getSelectionPath();
        boolean bookSelected = false;
        MapTableModel mtm = this.emptyTableModel;
        if (path != null && (bmd = this.getBookMetaData(last = path.getLastPathComponent())) != null) {
            mtm = new BookMetaDataTableModel(bmd);
            bookSelected = true;
        }
        this.tblSelected.setModel((TableModel)mtm);
        this.actions.getAction(INSTALL).setEnabled(bookSelected);
        this.actions.getAction(INSTALL_SEARCH).setEnabled(bookSelected);
    }

    public void setTreeModel(BookList books) {
        this.treAvailable.setModel(this.createTreeModel(books));
    }

    private final class CustomBooksListener
    implements BooksListener {
        private CustomBooksListener() {
        }

        public void bookAdded(BooksEvent ev) {
            SitePane.this.setTreeModel((BookList)ev.getSource());
        }

        public void bookRemoved(BooksEvent ev) {
            SitePane.this.setTreeModel((BookList)ev.getSource());
        }
    }
}

