/*
 * Decompiled with CFR 0.152.
 */
package org.crosswire.bibledesktop.book;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.FlowLayout;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import javax.swing.BorderFactory;
import javax.swing.JComboBox;
import javax.swing.JPanel;
import org.crosswire.bibledesktop.book.BibleComboBoxModelSet;
import org.crosswire.bibledesktop.book.BookListCellRenderer;
import org.crosswire.bibledesktop.book.BooksComboBoxModel;
import org.crosswire.bibledesktop.book.Msg;
import org.crosswire.bibledesktop.display.BookDataDisplay;
import org.crosswire.bibledesktop.display.BookDataDisplayFactory;
import org.crosswire.bibledesktop.display.URLEventListener;
import org.crosswire.bibledesktop.display.scrolled.ScrolledBookDataDisplay;
import org.crosswire.common.util.Reporter;
import org.crosswire.jsword.book.Book;
import org.crosswire.jsword.book.BookFilter;
import org.crosswire.jsword.book.BookFilters;
import org.crosswire.jsword.passage.Key;
import org.crosswire.jsword.passage.Passage;
import org.crosswire.jsword.passage.Verse;

public class CommentaryPane
extends JPanel
implements BookDataDisplay {
    protected Key key;
    private BookFilter filter = BookFilters.getCommentaries();
    private BookDataDisplay display = new ScrolledBookDataDisplay(BookDataDisplayFactory.createBookDataDisplay());
    private BooksComboBoxModel mdlcomments = new BooksComboBoxModel(this.filter);
    protected BibleComboBoxModelSet set = new BibleComboBoxModelSet();
    protected JComboBox cboComments = new JComboBox();
    private JComboBox cboBooks = new JComboBox();
    private JComboBox cboChaps = new JComboBox();
    private JComboBox cboVerse = new JComboBox();
    private JPanel pnlSelect = new JPanel();
    private JPanel pnlTop = new JPanel();
    private static final long serialVersionUID = 3258411737760804915L;

    public CommentaryPane() {
        this.init();
    }

    private void init() {
        this.set.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent ev) {
                CommentaryPane.this.updateDisplay();
            }
        });
        this.set.setBookComboBox(this.cboBooks);
        this.set.setChapterComboBox(this.cboChaps);
        this.set.setVerseComboBox(this.cboVerse);
        this.cboBooks.setToolTipText(Msg.SELECT_BOOK.toString());
        this.cboChaps.setToolTipText(Msg.SELECT_CHAPTER.toString());
        this.cboVerse.setToolTipText(Msg.SELECT_VERSE.toString());
        this.pnlSelect.setLayout(new FlowLayout());
        this.pnlSelect.add((Component)this.cboBooks, null);
        this.pnlSelect.add((Component)this.cboChaps, null);
        this.pnlSelect.add((Component)this.cboVerse, null);
        this.cboComments.setModel(this.mdlcomments);
        this.cboComments.setRenderer(new BookListCellRenderer());
        this.cboComments.setPrototypeDisplayValue("012345678901234567890123456789");
        this.cboComments.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent ev) {
                CommentaryPane.this.updateDisplay();
            }
        });
        this.pnlTop.setLayout(new BorderLayout());
        this.pnlTop.add((Component)this.pnlSelect, "North");
        this.pnlTop.add((Component)this.cboComments, "South");
        this.setLayout(new BorderLayout());
        this.setBorder(BorderFactory.createEmptyBorder(5, 5, 5, 5));
        this.add((Component)this.pnlTop, "North");
        this.add(this.display.getComponent(), "Center");
    }

    public Component getComponent() {
        return this;
    }

    protected void updateDisplay() {
        Book book = (Book)this.cboComments.getSelectedItem();
        if (book == null) {
            return;
        }
        try {
            Verse verse = this.set.getVerse();
            this.display.setBookData(book, (Key)verse);
        }
        catch (Exception ex) {
            Reporter.informUser((Object)this, (Throwable)ex);
        }
    }

    public void copy() {
        this.display.copy();
    }

    public Key getKey() {
        return this.key;
    }

    public Book getBook() {
        return (Book)this.cboComments.getSelectedItem();
    }

    public void setBookData(Book book, Key key) {
        this.cboComments.setSelectedItem(book);
        this.setKey(key);
    }

    public void refresh() {
        this.display.refresh();
    }

    public void setKey(Key key) {
        Passage ref;
        this.key = key;
        if (key != null && key instanceof Passage && (ref = (Passage)key).countVerses() > 0) {
            this.set.setVerse(ref.getVerseAt(0));
        }
        this.updateDisplay();
    }

    public void addURLEventListener(URLEventListener listener) {
        this.display.addURLEventListener(listener);
    }

    public void removeURLEventListener(URLEventListener listener) {
        this.display.removeURLEventListener(listener);
    }
}

