/*
 * Decompiled with CFR 0.152.
 */
package org.crosswire.bibledesktop.book;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import javax.swing.event.EventListenerList;
import javax.swing.event.TreeModelEvent;
import javax.swing.event.TreeModelListener;
import javax.swing.tree.TreeModel;
import javax.swing.tree.TreePath;
import org.crosswire.bibledesktop.book.Msg;
import org.crosswire.jsword.book.BookFilters;
import org.crosswire.jsword.book.BookList;
import org.crosswire.jsword.book.BookMetaData;
import org.crosswire.jsword.book.BookType;
import org.crosswire.jsword.book.Books;
import org.crosswire.jsword.book.BooksEvent;
import org.crosswire.jsword.book.BooksListener;

public class BooksTreeModel
implements TreeModel {
    private List bibles;
    private List commentaries;
    private List dictionaries;
    private CustomBooksListener li = new CustomBooksListener();
    private BookList books;
    protected static final String ROOT = Msg.BOOKS.toString();
    protected EventListenerList listenerList = new EventListenerList();

    public BooksTreeModel() {
        this((BookList)Books.installed());
    }

    public BooksTreeModel(BookList books) {
        this.books = books;
        this.cacheBooks();
    }

    public Object getRoot() {
        return ROOT;
    }

    public int getChildCount(Object parent) {
        if (parent == ROOT) {
            return 3;
        }
        if (parent == BookType.BIBLE) {
            return this.bibles.size();
        }
        if (parent == BookType.COMMENTARY) {
            return this.commentaries.size();
        }
        if (parent == BookType.DICTIONARY) {
            return this.dictionaries.size();
        }
        return 0;
    }

    public boolean isLeaf(Object node) {
        return node != ROOT && node != BookType.BIBLE && node != BookType.COMMENTARY && node != BookType.DICTIONARY;
    }

    public void addTreeModelListener(TreeModelListener tmli) {
        if (this.listenerList.getListenerCount() == 0) {
            this.books.addBooksListener((BooksListener)this.li);
        }
        this.listenerList.add(TreeModelListener.class, tmli);
    }

    public void removeTreeModelListener(TreeModelListener tmli) {
        this.listenerList.remove(TreeModelListener.class, tmli);
        if (this.listenerList.getListenerCount() == 0) {
            this.books.removeBooksListener((BooksListener)this.li);
        }
    }

    public Object getChild(Object parent, int index) {
        if (parent == ROOT) {
            switch (index) {
                case 0: {
                    return BookType.BIBLE;
                }
                case 1: {
                    return BookType.COMMENTARY;
                }
                case 2: {
                    return BookType.DICTIONARY;
                }
            }
            return null;
        }
        if (parent == BookType.BIBLE) {
            return this.bibles.get(index);
        }
        if (parent == BookType.COMMENTARY) {
            return this.commentaries.get(index);
        }
        if (parent == BookType.DICTIONARY) {
            return this.dictionaries.get(index);
        }
        return null;
    }

    public int getIndexOfChild(Object parent, Object child) {
        if (parent == ROOT) {
            if (child == BookType.BIBLE) {
                return 0;
            }
            if (child == BookType.COMMENTARY) {
                return 1;
            }
            if (child == BookType.DICTIONARY) {
                return 2;
            }
            return -1;
        }
        if (parent == BookType.BIBLE) {
            return this.bibles.indexOf(child);
        }
        if (parent == BookType.COMMENTARY) {
            return this.commentaries.indexOf(child);
        }
        if (parent == BookType.DICTIONARY) {
            return this.dictionaries.indexOf(child);
        }
        return -1;
    }

    public void valueForPathChanged(TreePath path, Object newValue) {
    }

    protected void fireTreeNodesInserted(Object source, Object[] path) {
        TreeModelEvent ev = new TreeModelEvent(source, path);
        Object[] listeners = this.listenerList.getListenerList();
        for (int i = listeners.length - 2; i >= 0; i -= 2) {
            if (listeners[i] != (class$javax$swing$event$TreeModelListener == null ? BooksTreeModel.class$("javax.swing.event.TreeModelListener") : class$javax$swing$event$TreeModelListener)) continue;
            ((TreeModelListener)listeners[i + 1]).treeNodesInserted(ev);
        }
    }

    protected void fireTreeNodesRemoved(Object source, Object[] path) {
        TreeModelEvent ev = new TreeModelEvent(source, path);
        Object[] listeners = this.listenerList.getListenerList();
        for (int i = listeners.length - 2; i >= 0; i -= 2) {
            if (listeners[i] != (class$javax$swing$event$TreeModelListener == null ? BooksTreeModel.class$("javax.swing.event.TreeModelListener") : class$javax$swing$event$TreeModelListener)) continue;
            ((TreeModelListener)listeners[i + 1]).treeNodesRemoved(ev);
        }
    }

    protected void fireTreeStructureChanged(Object source) {
        TreeModelEvent ev = new TreeModelEvent(source, new Object[]{ROOT});
        Object[] listeners = this.listenerList.getListenerList();
        for (int i = listeners.length - 2; i >= 0; i -= 2) {
            if (listeners[i] != (class$javax$swing$event$TreeModelListener == null ? BooksTreeModel.class$("javax.swing.event.TreeModelListener") : class$javax$swing$event$TreeModelListener)) continue;
            ((TreeModelListener)listeners[i + 1]).treeStructureChanged(ev);
        }
    }

    protected Object getChildOfRoot(BookMetaData bmd) {
        return bmd.getType();
    }

    protected final void cacheBooks() {
        this.bibles = new ArrayList();
        this.bibles.addAll(this.books.getBookMetaDatas(BookFilters.getBibles()));
        Collections.sort(this.bibles);
        this.commentaries = new ArrayList();
        this.commentaries.addAll(this.books.getBookMetaDatas(BookFilters.getCommentaries()));
        Collections.sort(this.commentaries);
        this.dictionaries = new ArrayList();
        this.dictionaries.addAll(this.books.getBookMetaDatas(BookFilters.getDictionaries()));
        Collections.sort(this.dictionaries);
    }

    private final class CustomBooksListener
    implements BooksListener {
        private CustomBooksListener() {
        }

        public void bookAdded(BooksEvent ev) {
            BooksTreeModel.this.cacheBooks();
            BooksTreeModel.this.fireTreeStructureChanged(ev.getSource());
        }

        public void bookRemoved(BooksEvent ev) {
            BooksTreeModel.this.cacheBooks();
            BooksTreeModel.this.fireTreeStructureChanged(ev.getSource());
        }
    }
}

