/*
 * Decompiled with CFR 0.152.
 */
package org.crosswire.bibledesktop.book;

import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Font;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.SystemColor;
import java.awt.Window;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import javax.swing.BorderFactory;
import javax.swing.ComboBoxModel;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JComboBox;
import javax.swing.JDialog;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTextArea;
import javax.swing.JTextField;
import javax.swing.KeyStroke;
import javax.swing.event.DocumentEvent;
import javax.swing.event.DocumentListener;
import org.crosswire.bibledesktop.book.Msg;
import org.crosswire.bibledesktop.book.PassageSelectionPane;
import org.crosswire.common.swing.ActionFactory;
import org.crosswire.common.swing.GuiUtil;
import org.crosswire.common.swing.LookAndFeelUtil;
import org.crosswire.common.util.Logger;
import org.crosswire.common.util.StringUtil;
import org.crosswire.jsword.book.search.parse.IndexSearcher;
import org.crosswire.jsword.book.search.parse.PassageLeftParamWord;
import org.crosswire.jsword.book.search.parse.PassageRightParamWord;
import org.crosswire.jsword.book.search.parse.PhraseParamWord;
import org.crosswire.jsword.book.search.parse.RemoveCommandWord;
import org.crosswire.jsword.book.search.parse.RetainCommandWord;

public class AdvancedSearchPane
extends JPanel
implements DocumentListener {
    private static final String DONE = "Done";
    private static final String PHRASE = "Phrase";
    private static final String RESTRICT = "Restrict";
    private static final String HEAD_RESTRICT = "HeadRestrict";
    private static final String HEAD_BASE = "HeadBase";
    private static final String INCLUDES = "Includes";
    private static final String EXCLUDES = "Excludes";
    private static final String PRESETS = "Presets";
    private static final String RESTRICT_SELECT = "RestrictSelect";
    private static final String HEAD_SUMMARY = "HeadSummary";
    private static final String SUMMARY = "Summary";
    private static final String SPACE = " ";
    private static final String PRESET_END = ")";
    private static final String PRESET_START = "(";
    protected boolean bailout;
    private ActionFactory actions;
    private String[] presets = Msg.PRESETS.toString().split("\\|");
    private boolean editingRestrict;
    private PassageSelectionPane dlgSelect;
    private JLabel lblPhrase;
    private JLabel lblIncludes;
    private JTextField txtIncludes;
    private JTextField txtPhrase;
    private JLabel lblExcludes;
    private JTextField txtExcludes;
    private JLabel lblHeading;
    private JCheckBox chkRestrict;
    private JLabel lblRestrict;
    private JTextField txtRestrict;
    private JButton btnRestrict;
    private JButton btnGo;
    private JLabel lblPresets;
    private JComboBox cboPresets;
    protected JDialog dlgMain;
    private JLabel lblSummary;
    private JCheckBox chkSummary;
    private JTextArea txtSummary;
    private JScrollPane scrSummary;
    private static final Logger log = Logger.getLogger((Class)AdvancedSearchPane.class);
    private static final long serialVersionUID = 3977303234983245108L;

    public AdvancedSearchPane() {
        this.initialize();
    }

    private void initialize() {
        this.actions = new ActionFactory(AdvancedSearchPane.class, (Object)this);
        JLabel temp = new JLabel();
        Color headBG = SystemColor.control.darker();
        Color headFG = Color.BLACK;
        Font headFont = temp.getFont().deriveFont(1);
        this.lblHeading = this.actions.createJLabel(HEAD_BASE);
        this.lblHeading.setBorder(BorderFactory.createLineBorder(headBG, 3));
        this.lblHeading.setBackground(headBG);
        this.lblHeading.setForeground(headFG);
        this.lblHeading.setFont(headFont);
        this.lblHeading.setOpaque(true);
        this.lblPhrase = this.actions.createJLabel(PHRASE);
        this.txtPhrase = new JTextField();
        this.txtPhrase.getDocument().addDocumentListener(this);
        this.txtIncludes = new JTextField();
        this.txtIncludes.getDocument().addDocumentListener(this);
        this.lblIncludes = this.actions.createJLabel(INCLUDES);
        this.lblIncludes.setLabelFor(this.txtIncludes);
        this.txtExcludes = new JTextField();
        this.txtExcludes.getDocument().addDocumentListener(this);
        this.lblExcludes = this.actions.createJLabel(EXCLUDES);
        this.lblExcludes.setLabelFor(this.txtExcludes);
        this.chkRestrict = new JCheckBox(this.actions.getAction(HEAD_RESTRICT));
        this.chkRestrict.setBackground(headBG);
        this.chkRestrict.setForeground(headFG);
        this.chkRestrict.setFont(headFont);
        this.lblPresets = this.actions.createJLabel(PRESETS);
        this.lblPresets.setVisible(false);
        this.cboPresets = new JComboBox<String>(this.presets);
        this.cboPresets.setVisible(false);
        this.cboPresets.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent ev) {
                AdvancedSearchPane.this.updatePreset();
            }
        });
        this.lblRestrict = this.actions.createJLabel(RESTRICT);
        this.lblRestrict.setVisible(false);
        this.txtRestrict = new JTextField();
        this.txtRestrict.setVisible(false);
        this.txtRestrict.getDocument().addDocumentListener(this);
        this.btnRestrict = new JButton(this.actions.getAction(RESTRICT_SELECT));
        this.btnRestrict.setVisible(false);
        this.chkSummary = new JCheckBox(this.actions.getAction(HEAD_SUMMARY));
        this.chkSummary.setBackground(headBG);
        this.chkSummary.setForeground(headFG);
        this.chkSummary.setFont(headFont);
        this.lblSummary = this.actions.createJLabel(SUMMARY);
        this.lblSummary.setVisible(false);
        this.txtSummary = new JTextArea();
        this.txtSummary.setBackground(SystemColor.control);
        this.txtSummary.setLineWrap(true);
        this.txtSummary.setEditable(false);
        this.txtSummary.setRows(2);
        this.scrSummary = new JScrollPane(this.txtSummary);
        this.scrSummary.setVisible(false);
        this.btnGo = new JButton(this.actions.getAction(DONE));
        this.setBorder(BorderFactory.createLineBorder(SystemColor.control, 5));
        this.setLayout(new GridBagLayout());
        this.add((Component)this.lblHeading, new GridBagConstraints(0, 1, 3, 1, 0.0, 0.0, 17, 2, new Insets(2, 2, 2, 2), 0, 0));
        this.add((Component)this.lblPhrase, new GridBagConstraints(0, 2, 1, 1, 0.0, 0.0, 13, 0, new Insets(0, 0, 0, 0), 0, 0));
        this.add((Component)this.txtPhrase, new GridBagConstraints(1, 2, 2, 1, 1.0, 0.0, 10, 2, new Insets(2, 5, 2, 5), 0, 0));
        this.add((Component)this.lblIncludes, new GridBagConstraints(0, 3, 1, 1, 0.0, 0.0, 13, 0, new Insets(0, 0, 0, 0), 0, 0));
        this.add((Component)this.txtIncludes, new GridBagConstraints(1, 3, 2, 1, 1.0, 0.0, 10, 2, new Insets(2, 5, 2, 5), 0, 0));
        this.add((Component)this.lblExcludes, new GridBagConstraints(0, 4, 1, 1, 0.0, 0.0, 13, 0, new Insets(0, 0, 0, 0), 0, 0));
        this.add((Component)this.txtExcludes, new GridBagConstraints(1, 4, 2, 1, 1.0, 0.0, 10, 2, new Insets(2, 5, 2, 5), 0, 0));
        this.add((Component)this.chkRestrict, new GridBagConstraints(0, 5, 3, 1, 0.0, 0.0, 17, 2, new Insets(2, 2, 2, 2), 0, 0));
        this.add((Component)this.lblPresets, new GridBagConstraints(0, 6, 1, 1, 0.0, 0.0, 13, 0, new Insets(0, 0, 0, 0), 0, 0));
        this.add((Component)this.cboPresets, new GridBagConstraints(1, 6, 2, 1, 1.0, 0.0, 10, 2, new Insets(2, 5, 2, 5), 0, 0));
        this.add((Component)this.lblRestrict, new GridBagConstraints(0, 7, 1, 1, 0.0, 0.0, 13, 0, new Insets(0, 0, 0, 0), 0, 0));
        this.add((Component)this.txtRestrict, new GridBagConstraints(1, 7, 1, 1, 1.0, 0.0, 10, 2, new Insets(2, 5, 2, 5), 0, 0));
        this.add((Component)this.btnRestrict, new GridBagConstraints(2, 7, 1, 1, 0.0, 0.0, 10, 0, new Insets(0, 0, 0, 5), 0, 0));
        this.add((Component)this.chkSummary, new GridBagConstraints(0, 16, 3, 1, 0.0, 0.0, 17, 2, new Insets(2, 2, 2, 2), 0, 0));
        this.add((Component)this.lblSummary, new GridBagConstraints(0, 17, 1, 1, 0.0, 0.0, 13, 0, new Insets(0, 0, 0, 0), 0, 0));
        this.add((Component)this.scrSummary, new GridBagConstraints(1, 17, 2, 1, 1.0, 1.0, 10, 1, new Insets(2, 5, 2, 5), 0, 0));
        this.add((Component)this.btnGo, new GridBagConstraints(2, 18, 1, 1, 0.0, 0.0, 15, 0, new Insets(10, 0, 5, 5), 0, 0));
    }

    public String showInDialog(Component parent, String title, boolean modal, String search) {
        this.txtSummary.setText(search);
        this.dlgMain = new JDialog(JOptionPane.getFrameForComponent(parent));
        KeyStroke esc = KeyStroke.getKeyStroke(27, 0);
        this.bailout = true;
        ActionListener closer = new ActionListener(){

            public void actionPerformed(ActionEvent ev) {
                AdvancedSearchPane.this.dlgMain.dispose();
            }
        };
        this.dlgMain.getContentPane().setLayout(new BorderLayout());
        this.dlgMain.getContentPane().add((Component)this, "Center");
        this.dlgMain.getRootPane().setDefaultButton(this.btnGo);
        this.dlgMain.getRootPane().registerKeyboardAction(closer, esc, 2);
        this.dlgMain.setDefaultCloseOperation(2);
        this.dlgMain.setTitle(title);
        this.dlgMain.setModal(modal);
        GuiUtil.restrainedPack((Window)this.dlgMain, (float)0.5f, (float)0.75f);
        GuiUtil.centerWindow((Window)this.dlgMain);
        this.dlgMain.setVisible(true);
        if (this.bailout) {
            return null;
        }
        return this.txtSummary.getText();
    }

    public void doHeadRestrict() {
        boolean visible = this.chkRestrict.isSelected();
        this.lblPresets.setVisible(visible);
        this.cboPresets.setVisible(visible);
        this.lblRestrict.setVisible(visible);
        this.txtRestrict.setVisible(visible);
        this.btnRestrict.setVisible(visible);
        if (this.dlgMain != null) {
            this.dlgMain.pack();
        }
    }

    public void doHeadSummary() {
        boolean visible = this.chkSummary.isSelected();
        this.lblSummary.setVisible(visible);
        this.scrSummary.setVisible(visible);
        if (this.dlgMain != null) {
            this.dlgMain.pack();
        }
    }

    public void doHeadOriginal() {
    }

    public void doHeadTime() {
    }

    public void doRestrictSelect() {
        String passg;
        if (this.dlgSelect == null) {
            this.dlgSelect = new PassageSelectionPane();
        }
        if ((passg = this.dlgSelect.showInDialog(this, Msg.ADVANCED_SELECT_TITLE.toString(), true, this.txtRestrict.getText())) != null) {
            this.cboPresets.setSelectedItem(this.presets[this.presets.length - 1]);
            this.txtRestrict.setText(passg);
        }
    }

    public void doDone() {
        this.bailout = false;
        this.dlgMain.dispose();
    }

    public void updatePreset() {
        if (this.editingRestrict) {
            return;
        }
        String include = "";
        String preset = (String)this.cboPresets.getSelectedItem();
        if (preset != null) {
            int open = preset.indexOf(PRESET_START);
            int close = preset.indexOf(PRESET_END);
            if (open != -1 && close != -1) {
                include = preset.substring(open + 1, close);
            }
        }
        this.txtRestrict.setText(include);
    }

    private void updateSearchString() {
        String restrict;
        String excludes;
        String includes;
        String quote = IndexSearcher.getPreferredSyntax((Class)PhraseParamWord.class);
        String plus = IndexSearcher.getPreferredSyntax((Class)RetainCommandWord.class);
        String minus = IndexSearcher.getPreferredSyntax((Class)RemoveCommandWord.class);
        String open = IndexSearcher.getPreferredSyntax((Class)PassageLeftParamWord.class);
        String close = IndexSearcher.getPreferredSyntax((Class)PassageRightParamWord.class);
        StringBuffer search = new StringBuffer();
        String phrase = this.txtPhrase.getText();
        if (phrase != null && phrase.trim().length() > 0) {
            search.append(quote);
            search.append(phrase);
            search.append(quote);
        }
        if ((includes = this.txtIncludes.getText()) != null && includes.trim().length() > 0) {
            if (search.length() != 0) {
                search.append(SPACE);
            }
            Object[] words = includes.split(SPACE);
            search.append(plus);
            search.append(StringUtil.join((Object[])words, (String)(SPACE + plus)));
        }
        if ((excludes = this.txtExcludes.getText()) != null && excludes.trim().length() > 0) {
            if (search.length() != 0) {
                search.append(SPACE);
            }
            Object[] words = excludes.split(SPACE);
            search.append(minus);
            search.append(StringUtil.join((Object[])words, (String)(SPACE + minus)));
        }
        if ((restrict = this.txtRestrict.getText()) != null && restrict.trim().length() > 0) {
            if (search.length() != 0) {
                search.append(SPACE);
            }
            search.append(plus);
            search.append(open);
            search.append(restrict);
            search.append(close);
        }
        this.txtSummary.setText(search.toString());
        this.editingRestrict = true;
        boolean match = false;
        ComboBoxModel model = this.cboPresets.getModel();
        String find = PRESET_START + restrict + PRESET_END;
        for (int i = 0; !match && i < model.getSize(); ++i) {
            String element = (String)model.getElementAt(i);
            if (element.indexOf(find) == -1) continue;
            this.cboPresets.setSelectedIndex(i);
            match = true;
        }
        if (!match) {
            this.cboPresets.setSelectedItem(this.presets[this.presets.length - 1]);
        }
        this.editingRestrict = false;
    }

    public void changedUpdate(DocumentEvent ev) {
        this.updateSearchString();
    }

    public void insertUpdate(DocumentEvent ev) {
        this.updateSearchString();
    }

    public void removeUpdate(DocumentEvent ev) {
        this.updateSearchString();
    }

    public static void main(String[] args) {
        LookAndFeelUtil.initialize();
        AdvancedSearchPane adv = new AdvancedSearchPane();
        String reply = adv.showInDialog(null, "Advanced Search", true, "test");
        log.debug(reply);
        System.exit(0);
    }
}

