/*
 * Decompiled with CFR 0.152.
 */
package org.crosswire.common.swing;

import java.util.Enumeration;
import javax.swing.LookAndFeel;
import javax.swing.UIManager;
import javax.swing.UnsupportedLookAndFeelException;
import javax.swing.plaf.FontUIResource;
import javax.swing.plaf.metal.MetalLookAndFeel;
import org.crosswire.common.swing.CWOptionPane;
import org.crosswire.common.swing.CWOtherMsg;
import org.crosswire.common.swing.GuiConvert;
import org.crosswire.common.swing.plaf.MetalLFCustoms;
import org.crosswire.common.swing.plaf.OtherLFCustoms;
import org.crosswire.common.swing.plaf.WindowsLFCustoms;
import org.crosswire.common.util.ClassUtil;

public final class LookAndFeelUtil {
    private static Class<LookAndFeel> currentLAF;
    private static Class<?> defaultLAF;
    private static String font;

    private LookAndFeelUtil() {
    }

    public static void initialize() {
    }

    public static Class<?> getLookAndFeel() {
        if (currentLAF == null) {
            return defaultLAF;
        }
        return currentLAF;
    }

    public static void setLookAndFeel(Class<LookAndFeel> newLaFClass) throws InstantiationException, IllegalAccessException, UnsupportedLookAndFeelException {
        LookAndFeel laf = newLaFClass.newInstance();
        if (currentLAF != null && !currentLAF.equals(newLaFClass)) {
            CWOptionPane.showMessageDialog(null, CWOtherMsg.lookupText("The Look and Feel will change on the next startup.", new Object[0]));
        } else {
            UIManager.setLookAndFeel(laf);
        }
        currentLAF = newLaFClass;
    }

    public static String getFont() {
        return font;
    }

    public static FontUIResource toFontUIResource() {
        return new FontUIResource(GuiConvert.string2Font(font));
    }

    public static void setFont(String font) {
        LookAndFeelUtil.font = font;
        LookAndFeelUtil.setUIFont(LookAndFeelUtil.toFontUIResource());
    }

    public static void setUIFont(FontUIResource f) {
        Enumeration keys = UIManager.getDefaults().keys();
        while (keys.hasMoreElements()) {
            Object key = keys.nextElement();
            Object value = UIManager.get(key);
            if (!(value instanceof FontUIResource)) continue;
            UIManager.put(key, f);
        }
    }

    private static void customizeBDLookandFeel() {
        String currentLF = UIManager.getLookAndFeel().getClass().getName();
        if (currentLF.indexOf("MetalLookAndFeel") != -1) {
            new MetalLFCustoms().initUIDefaults();
        } else if (currentLF.indexOf("WindowsLookAndFeel") != -1) {
            new WindowsLFCustoms().initUIDefaults();
        } else {
            new OtherLFCustoms().initUIDefaults();
        }
    }

    static {
        block9: {
            font = "Dialog-PLAIN-12";
            defaultLAF = MetalLookAndFeel.class;
            String systemLAF = UIManager.getSystemLookAndFeelClassName();
            try {
                if (systemLAF.indexOf("WindowsLookAndFeel") != -1 || systemLAF.indexOf("AquaLookAndfeel") != -1) {
                    UIManager.setLookAndFeel(systemLAF);
                    defaultLAF = ClassUtil.forName((String)systemLAF);
                }
            }
            catch (ClassNotFoundException e) {
                assert (false);
            }
            catch (InstantiationException e) {
                assert (false);
            }
            catch (IllegalAccessException e) {
                assert (false);
            }
            catch (UnsupportedLookAndFeelException e) {
                if ($assertionsDisabled) break block9;
                throw new AssertionError();
            }
        }
        LookAndFeelUtil.customizeBDLookandFeel();
    }
}

