/*
 * Decompiled with CFR 0.152.
 */
package org.crosswire.bibledesktop.passage;

import java.util.Enumeration;
import java.util.Iterator;
import javax.swing.tree.TreeNode;
import org.crosswire.common.util.EmptyIterator;
import org.crosswire.common.util.IteratorEnumeration;
import org.crosswire.jsword.passage.Key;

public class KeyTreeNode
implements TreeNode {
    private Key key;
    private TreeNode parent;

    public KeyTreeNode(Key key, TreeNode parent) {
        this.key = key;
        this.parent = parent;
    }

    @Override
    public int getChildCount() {
        return this.key == null ? 0 : this.key.getChildCount();
    }

    @Override
    public boolean getAllowsChildren() {
        return this.key != null && this.key.canHaveChildren();
    }

    @Override
    public boolean isLeaf() {
        return this.key == null || this.key.isEmpty();
    }

    public Enumeration<Key> children() {
        if (this.key != null) {
            return new IteratorEnumeration(this.key.iterator());
        }
        return new IteratorEnumeration((Iterator)new EmptyIterator());
    }

    @Override
    public TreeNode getParent() {
        return this.parent;
    }

    @Override
    public TreeNode getChildAt(int index) {
        Key child = this.key.get(index);
        return new KeyTreeNode(child, this);
    }

    @Override
    public int getIndex(TreeNode node) {
        if (this.key != null && node instanceof KeyTreeNode) {
            KeyTreeNode keynode = (KeyTreeNode)node;
            Key that = keynode.getKey();
            return this.key.indexOf(that);
        }
        return -1;
    }

    public Key getKey() {
        return this.key;
    }
}

