/*
 * Decompiled with CFR 0.152.
 */
package org.crosswire.bibledesktop.display.basic;

import java.awt.Component;
import java.net.URI;
import java.util.Locale;
import javax.swing.JToolTip;
import javax.swing.ToolTipManager;
import javax.xml.transform.TransformerException;
import org.crosswire.bibledesktop.book.install.BookFont;
import org.crosswire.bibledesktop.desktop.XSLTProperty;
import org.crosswire.bibledesktop.display.URIEvent;
import org.crosswire.bibledesktop.display.URIEventListener;
import org.crosswire.bibledesktop.display.basic.FullHTMLTip;
import org.crosswire.common.swing.GuiConvert;
import org.crosswire.common.swing.GuiUtil;
import org.crosswire.common.util.LucidException;
import org.crosswire.common.util.Reporter;
import org.crosswire.common.xml.Converter;
import org.crosswire.common.xml.SAXEventProvider;
import org.crosswire.common.xml.TransformingSAXEventProvider;
import org.crosswire.common.xml.XMLUtil;
import org.crosswire.jsword.book.Book;
import org.crosswire.jsword.book.BookCategory;
import org.crosswire.jsword.book.BookData;
import org.crosswire.jsword.book.BookException;
import org.crosswire.jsword.book.BookMetaData;
import org.crosswire.jsword.book.Books;
import org.crosswire.jsword.book.Defaults;
import org.crosswire.jsword.passage.NoSuchKeyException;
import org.xml.sax.SAXException;

public class URITipHelper
implements URIEventListener {
    private int formerDismissDelay;
    private int myDismissDelay = 60000;
    private FullHTMLTip tip = new FullHTMLTip();
    private URIEvent event;
    private String txt;

    public JToolTip fetchToolTip() {
        return this.tip;
    }

    public String retrieve(Converter converter) {
        if (this.event == null) {
            return null;
        }
        if (this.txt != null) {
            return this.txt;
        }
        String protocol = this.event.getScheme();
        Book book = null;
        if (protocol.equals("gdef")) {
            book = Defaults.getGreekDefinitions();
        } else if (protocol.equals("hdef")) {
            book = Defaults.getHebrewDefinitions();
        } else if (protocol.equals("gmorph")) {
            book = Defaults.getGreekParse();
        } else if (protocol.equals("hmorph")) {
            book = Defaults.getHebrewParse();
        }
        if (book == null || Books.installed().getBook(book.getName()) == null) {
            return "Book Unavailable!";
        }
        BookData bdata = null;
        try {
            bdata = new BookData(book, book.getKey(this.event.getURI()));
        }
        catch (NoSuchKeyException ex) {
            return ex.getDetailedMessage();
        }
        assert (book == bdata.getFirstBook());
        BookMetaData bmd = book.getBookMetaData();
        if (bmd == null) {
            return "Book Meta Data Unavailable!";
        }
        boolean direction = bmd.isLeftToRight();
        GuiUtil.applyOrientation((Component)this.tip.getTextView(), direction);
        this.tip.getTextView().setLocale(new Locale(bmd.getLanguage().getCode()));
        String fontSpec = GuiConvert.font2String(BookFont.instance().getFont(book));
        try {
            SAXEventProvider osissep = bdata.getSAXEventProvider();
            TransformingSAXEventProvider htmlsep = (TransformingSAXEventProvider)converter.convert(osissep);
            XSLTProperty.DIRECTION.setState(direction ? "ltr" : "rtl");
            URI loc = bmd.getLocation();
            XSLTProperty.BASE_URL.setState(loc == null ? "" : loc.getPath());
            if (bmd.getBookCategory() == BookCategory.BIBLE) {
                XSLTProperty.setProperties(htmlsep);
            } else {
                XSLTProperty.CSS.setProperty(htmlsep);
                XSLTProperty.BASE_URL.setProperty(htmlsep);
                XSLTProperty.DIRECTION.setProperty(htmlsep);
            }
            htmlsep.setParameter(XSLTProperty.FONT.getName(), (Object)fontSpec);
            this.txt = XMLUtil.writeToString((SAXEventProvider)htmlsep);
        }
        catch (SAXException e) {
            Reporter.informUser((Object)this, (Throwable)e);
            e.printStackTrace();
            this.txt = e.getMessage();
        }
        catch (TransformerException e) {
            Reporter.informUser((Object)this, (Throwable)e);
            e.printStackTrace();
            this.txt = e.getMessage();
        }
        catch (BookException e) {
            Reporter.informUser((Object)this, (LucidException)e);
            e.printStackTrace();
            this.txt = e.getMessage();
        }
        return this.txt;
    }

    public String getTipTitle() {
        if (this.event == null) {
            return "Untitled Tip";
        }
        return this.event.getURI();
    }

    @Override
    public void activateURI(URIEvent ev) {
    }

    @Override
    public void enterURI(URIEvent ev) {
        if (!this.interested(ev)) {
            return;
        }
        this.formerDismissDelay = ToolTipManager.sharedInstance().getDismissDelay();
        ToolTipManager.sharedInstance().setDismissDelay(this.myDismissDelay);
        this.event = ev;
    }

    @Override
    public void leaveURI(URIEvent ev) {
        if (!this.interested(ev)) {
            return;
        }
        ToolTipManager.sharedInstance().setDismissDelay(this.formerDismissDelay);
        this.event = null;
        this.txt = null;
    }

    boolean interested(URIEvent ev) {
        String protocol = ev.getScheme();
        if (protocol.equals("gdef")) {
            return true;
        }
        if (protocol.equals("hdef")) {
            return true;
        }
        if (protocol.equals("gmorph")) {
            return true;
        }
        return protocol.equals("hmorph");
    }
}

