/*
 * Decompiled with CFR 0.152.
 */
package org.crosswire.bibledesktop.book.install;

import java.awt.Font;
import org.crosswire.bibledesktop.desktop.XSLTProperty;
import org.crosswire.common.swing.FontStore;
import org.crosswire.common.swing.GuiConvert;
import org.crosswire.common.util.CWProject;
import org.crosswire.common.util.Language;
import org.crosswire.jsword.book.Book;

public final class BookFont
extends FontStore {
    private static BookFont fonts = new BookFont();

    private BookFont() {
        super("BookFonts", CWProject.instance().getWritableProjectDir());
    }

    public static BookFont instance() {
        return fonts;
    }

    public void setFont(Book book, Font font) {
        super.setFont(book.getInitials(), font);
    }

    public Font getFont(Book book) {
        Font bookFont;
        String fontName = book.getBookMetaData().getProperty("Font");
        String fontSpec = XSLTProperty.FONT.getStringState();
        if (fontName != null && (bookFont = GuiConvert.deriveFont(fontSpec, fontName)).getFamily().equalsIgnoreCase(fontName)) {
            fontSpec = GuiConvert.font2String(bookFont);
        }
        return fonts.getFont(book.getInitials(), book.getLanguage(), fontSpec);
    }

    public Font getFont(Language language) {
        return fonts.getFont(null, language, null);
    }

    public boolean isSet(Book book, Language lang) {
        if (book != null) {
            return this.getFontMap().get(book.getInitials()) != null;
        }
        if (lang != null) {
            return this.getFontMap().get("lang." + lang.getCode()) != null;
        }
        return false;
    }

    public void resetFont(Book book, Language lang) {
        if (book != null) {
            this.resetFont(book.getInitials());
        }
        if (lang != null) {
            this.resetFont("lang." + lang.getCode());
        }
    }
}

