/*
 * Decompiled with CFR 0.152.
 */
package org.crosswire.bibledesktop.book;

import java.awt.Component;
import java.awt.FlowLayout;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.util.ArrayList;
import java.util.Comparator;
import javax.swing.JButton;
import javax.swing.JComboBox;
import javax.swing.JPanel;
import javax.swing.event.EventListenerList;
import org.crosswire.bibledesktop.BDMsg;
import org.crosswire.bibledesktop.book.BookListCellRenderer;
import org.crosswire.bibledesktop.book.BookSelectEvent;
import org.crosswire.bibledesktop.book.BookSelectListener;
import org.crosswire.bibledesktop.book.BooksComboBoxModel;
import org.crosswire.common.swing.ActionFactory;
import org.crosswire.common.swing.CWAction;
import org.crosswire.common.swing.GuiUtil;
import org.crosswire.jsword.book.Book;
import org.crosswire.jsword.book.BookFilter;
import org.crosswire.jsword.book.BookProvider;

public class ParallelBookPicker
extends JPanel
implements BookProvider {
    private transient BookFilter filter;
    private transient Comparator<Book> comparator;
    private transient ActionFactory actions;
    private transient EventListenerList listeners;
    private static final int MAX_PICKERS = 5;
    private static int maxPickers = 5;
    private static final long serialVersionUID = 1633401996774729671L;

    public ParallelBookPicker(BookFilter filter, Comparator<Book> comparator) {
        this.filter = filter;
        this.comparator = comparator;
        this.initialize();
    }

    private void initialize() {
        this.setLayout(new FlowLayout(3, 1, 1));
        this.listeners = new EventListenerList();
        this.actions = new ActionFactory(this);
        JPanel buttonBox = new JPanel(new FlowLayout(3, 0, 0));
        CWAction action = this.actions.addAction("RemovePicker");
        action.setTooltip(BDMsg.gettext("Remove a parallel Bible", new Object[0]));
        action.setSmallIcon("images/subtract-13.png");
        buttonBox.add(GuiUtil.flatten(new JButton(action)));
        action = this.actions.addAction("AddPicker");
        action.setTooltip(BDMsg.gettext("Add a parallel Bible", new Object[0]));
        action.setSmallIcon("images/add-13.png");
        buttonBox.add(GuiUtil.flatten(new JButton(action)));
        this.add(buttonBox);
        this.doAddPicker();
    }

    public void doAddPicker() {
        BooksComboBoxModel mdlBook = new BooksComboBoxModel(this.filter, this.comparator);
        JComboBox<Object> cboBook = new JComboBox<Object>(mdlBook);
        cboBook.setPrototypeDisplayValue("0123456789");
        cboBook.setRenderer(new BookListCellRenderer(true));
        cboBook.addItemListener(new SelectedItemListener(this));
        cboBook.addActionListener(new SelectedActionListener());
        this.add(cboBook);
        Book book = mdlBook.getSelectedBook();
        if (book != null) {
            cboBook.setToolTipText(book.getName());
        }
        this.enableButtons();
        GuiUtil.applyDefaultOrientation(this);
        GuiUtil.refresh(this);
        this.fireBooksChosen(new BookSelectEvent(this));
    }

    public void doRemovePicker() {
        int size = this.getComponentCount();
        if (size > 2) {
            this.remove(size - 1);
            this.enableButtons();
            GuiUtil.refresh(this);
            this.fireBooksChosen(new BookSelectEvent(this));
        }
    }

    public Book[] getBooks() {
        ArrayList<Book> books = new ArrayList<Book>();
        int count = this.getComponentCount();
        for (int i = 1; i < count; ++i) {
            JComboBox combo;
            Book book;
            Component comp = this.getComponent(i);
            if (!(comp instanceof JComboBox) || (book = (Book)(combo = (JComboBox)comp).getSelectedItem()) == null) continue;
            books.add(book);
        }
        return books.toArray(new Book[books.size()]);
    }

    public Book getFirstBook() {
        int count = this.getComponentCount();
        for (int i = 1; i < count; ++i) {
            Component comp = this.getComponent(i);
            if (!(comp instanceof JComboBox)) continue;
            JComboBox combo = (JComboBox)comp;
            return (Book)combo.getSelectedItem();
        }
        return null;
    }

    public static int getMaxPickers() {
        return maxPickers;
    }

    public static void setMaxPickers(int maxPickers) {
        ParallelBookPicker.maxPickers = maxPickers;
    }

    public synchronized void addBookListener(BookSelectListener li) {
        this.listeners.add(BookSelectListener.class, li);
    }

    public synchronized void removeBookListener(BookSelectListener li) {
        this.listeners.remove(BookSelectListener.class, li);
    }

    protected void fireBooksChosen(BookSelectEvent ev) {
        Object[] contents = this.listeners.getListenerList();
        for (int i = contents.length - 2; i >= 0; i -= 2) {
            if (contents[i] != BookSelectListener.class) continue;
            ((BookSelectListener)contents[i + 1]).booksChosen(ev);
        }
    }

    public void enableButtons() {
        int count = this.getComponentCount() - 1;
        this.actions.findAction("RemovePicker").setEnabled(count > 1);
        this.actions.findAction("AddPicker").setEnabled(count < maxPickers);
        this.getComponent(0).setVisible(maxPickers >= 2 || count > maxPickers);
    }

    private void readObject(ObjectInputStream is) throws IOException, ClassNotFoundException {
        this.filter = null;
        this.comparator = null;
        this.listeners = new EventListenerList();
        this.actions = new ActionFactory(this);
        is.defaultReadObject();
    }

    static final class SelectedActionListener
    implements ActionListener {
        SelectedActionListener() {
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            JComboBox cbo = (JComboBox)e.getSource();
            if (cbo.getSelectedIndex() == -1 && cbo.getItemCount() > 0) {
                cbo.setSelectedIndex(0);
            }
        }
    }

    final class SelectedItemListener
    implements ItemListener,
    BookProvider {
        private ParallelBookPicker picker;

        SelectedItemListener(ParallelBookPicker picker) {
            this.picker = picker;
        }

        @Override
        public void itemStateChanged(ItemEvent ev) {
            if (ev.getStateChange() == 1) {
                JComboBox combo = (JComboBox)ev.getSource();
                Book selected = (Book)combo.getSelectedItem();
                ParallelBookPicker.this.fireBooksChosen(new BookSelectEvent(this));
                combo.setToolTipText(selected.getName());
            }
        }

        public Book[] getBooks() {
            return this.picker.getBooks();
        }

        public Book getFirstBook() {
            return this.picker.getFirstBook();
        }
    }
}

