/*
 * Decompiled with CFR 0.152.
 */
package org.crosswire.jsword.versification;

import java.io.IOException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.MissingResourceException;
import org.crosswire.common.config.ConfigException;
import org.crosswire.jsword.passage.Passage;
import org.crosswire.jsword.passage.RangedPassage;
import org.crosswire.jsword.passage.Verse;
import org.crosswire.jsword.passage.VerseKey;
import org.crosswire.jsword.versification.FileVersificationMapping;
import org.crosswire.jsword.versification.QualifiedKey;
import org.crosswire.jsword.versification.Versification;
import org.crosswire.jsword.versification.VersificationToKJVMapper;
import org.crosswire.jsword.versification.system.Versifications;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class VersificationsMapper {
    private static volatile VersificationsMapper instance;
    private static final Versification KJV;
    private static final Map<Versification, VersificationToKJVMapper> MAPPERS;
    private static final Logger LOGGER;

    private VersificationsMapper() {
        MAPPERS.put(KJV, null);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static VersificationsMapper instance() {
        if (instance != null) return instance;
        Class<VersificationsMapper> clazz = VersificationsMapper.class;
        synchronized (VersificationsMapper.class) {
            if (instance != null) return instance;
            instance = new VersificationsMapper();
            // ** MonitorExit[var0] (shouldn't be in output)
            return instance;
        }
    }

    public Passage map(Passage key, Versification target) {
        if (key.getVersification().equals(target)) {
            return key;
        }
        RangedPassage newPassage = new RangedPassage(target);
        for (Verse verse : key) {
            newPassage.addAll(this.mapVerse(verse, target));
        }
        return newPassage;
    }

    public VerseKey mapVerse(Verse v, Versification targetVersification) {
        ArrayList<QualifiedKey> kjvVerses;
        if (v.getVersification().equals(targetVersification)) {
            return v;
        }
        this.ensure(v.getVersification());
        this.ensure(targetVersification);
        VersificationToKJVMapper mapper = MAPPERS.get(v.getVersification());
        if (mapper == null) {
            kjvVerses = new ArrayList();
            Verse reversifiedVerse = v.reversify(KJV);
            if (reversifiedVerse != null) {
                kjvVerses.add(new QualifiedKey(reversifiedVerse));
            }
        } else {
            kjvVerses = mapper.map(new QualifiedKey(v));
        }
        if (KJV.equals(targetVersification)) {
            return this.getKeyFromQualifiedKeys(KJV, kjvVerses);
        }
        VersificationToKJVMapper targetMapper = MAPPERS.get(targetVersification);
        if (targetMapper == null) {
            return this.guessKeyFromKjvVerses(targetVersification, kjvVerses);
        }
        RangedPassage finalKeys = new RangedPassage(targetVersification);
        for (QualifiedKey qualifiedKey : kjvVerses) {
            VerseKey verseKey = targetMapper.unmap(qualifiedKey);
            if (verseKey == null) continue;
            finalKeys.addAll(verseKey);
        }
        return finalKeys;
    }

    private VerseKey guessKeyFromKjvVerses(Versification targetVersification, List<QualifiedKey> kjvVerses) {
        RangedPassage finalKeys = new RangedPassage(targetVersification);
        for (QualifiedKey qualifiedKey : kjvVerses) {
            VerseKey key;
            if (qualifiedKey.getKey() == null || (key = qualifiedKey.reversify(targetVersification).getKey()) == null) continue;
            finalKeys.addAll(key);
        }
        return finalKeys;
    }

    private VerseKey getKeyFromQualifiedKeys(Versification versification, List<QualifiedKey> kjvVerses) {
        RangedPassage finalKey = new RangedPassage(versification);
        for (QualifiedKey k : kjvVerses) {
            if (k.getKey() == null) continue;
            finalKey.addAll(k.getKey());
        }
        return finalKey;
    }

    public void ensureMappingDataLoaded(Versification versification) {
        this.ensure(versification);
    }

    private void ensure(Versification versification) {
        if (MAPPERS.containsKey(versification)) {
            return;
        }
        try {
            MAPPERS.put(versification, new VersificationToKJVMapper(versification, new FileVersificationMapping(versification)));
        }
        catch (IOException e) {
            LOGGER.error("Failed to load versification mappings for versification [{}]", (Object)versification, (Object)e);
            MAPPERS.put(versification, null);
        }
        catch (ConfigException e) {
            LOGGER.error("Failed to load versification mappings for versification [{}]", (Object)versification, (Object)e);
            MAPPERS.put(versification, null);
        }
        catch (MissingResourceException e) {
            LOGGER.error("Failed to load versification mappings for versification [{}]", (Object)versification, (Object)e);
            MAPPERS.put(versification, null);
        }
    }

    static {
        KJV = Versifications.instance().getVersification("KJV");
        MAPPERS = new HashMap<Versification, VersificationToKJVMapper>();
        LOGGER = LoggerFactory.getLogger(VersificationsMapper.class);
    }
}

