/*
 * Decompiled with CFR 0.152.
 */
package org.crosswire.jsword.passage;

import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.util.Iterator;
import java.util.NoSuchElementException;
import java.util.Set;
import java.util.TreeSet;
import org.crosswire.jsword.passage.AbstractPassage;
import org.crosswire.jsword.passage.Key;
import org.crosswire.jsword.passage.NoSuchVerseException;
import org.crosswire.jsword.passage.RestrictionType;
import org.crosswire.jsword.passage.Verse;
import org.crosswire.jsword.passage.VerseRange;
import org.crosswire.jsword.versification.Versification;

public class RangedPassage
extends AbstractPassage {
    private static final long serialVersionUID = 955115811339960826L;
    private transient Set<VerseRange> store = new TreeSet<VerseRange>();

    public RangedPassage(Versification refSystem) {
        super(refSystem);
    }

    protected RangedPassage(Versification v11n, String refs, Key basis) throws NoSuchVerseException {
        super(v11n, refs);
        this.addVerses(refs, basis);
        this.normalize();
    }

    protected RangedPassage(Versification v11n, String refs) throws NoSuchVerseException {
        this(v11n, refs, null);
    }

    @Override
    public RangedPassage clone() {
        RangedPassage copy = (RangedPassage)super.clone();
        copy.store = new TreeSet<VerseRange>();
        copy.store.addAll(this.store);
        return copy;
    }

    @Override
    public int countRanges(RestrictionType restrict) {
        if (restrict.equals((Object)RestrictionType.NONE)) {
            return this.store.size();
        }
        return super.countRanges(restrict);
    }

    @Override
    public int countVerses() {
        Iterator<VerseRange> it = this.rangeIterator(RestrictionType.NONE);
        int count = 0;
        while (it.hasNext()) {
            VerseRange range = it.next();
            count += range.getCardinality();
        }
        return count;
    }

    @Override
    public Iterator<Key> iterator() {
        return new VerseIterator(this.getVersification(), this.rangeIterator(RestrictionType.NONE));
    }

    @Override
    public final Iterator<VerseRange> rangeIterator(RestrictionType restrict) {
        if (restrict.equals((Object)RestrictionType.NONE)) {
            return this.store.iterator();
        }
        return new VerseRangeIterator(this.store.iterator(), restrict);
    }

    @Override
    public boolean isEmpty() {
        return this.store.isEmpty();
    }

    @Override
    public boolean contains(Key obj) {
        VerseRange that_range = RangedPassage.toVerseRange(this.getVersification(), obj);
        Iterator<VerseRange> it = this.rangeIterator(RestrictionType.NONE);
        while (it.hasNext()) {
            VerseRange this_range = it.next();
            if (!this_range.contains(that_range)) continue;
            return true;
        }
        return false;
    }

    @Override
    public void add(Key obj) {
        this.optimizeWrites();
        VerseRange that_range = RangedPassage.toVerseRange(this.getVersification(), obj);
        this.store.add(that_range);
        this.normalize();
        if (this.suppressEvents == 0) {
            this.fireIntervalAdded(this, that_range.getStart(), that_range.getEnd());
        }
    }

    @Override
    public void clear() {
        this.optimizeWrites();
        this.store.clear();
        this.fireIntervalRemoved(this, null, null);
    }

    @Override
    public void remove(Key obj) {
        this.optimizeWrites();
        VerseRange that_range = RangedPassage.toVerseRange(this.getVersification(), obj);
        boolean removed = false;
        TreeSet<VerseRange> new_store = new TreeSet<VerseRange>();
        new_store.addAll(this.store);
        for (Key key : new_store) {
            VerseRange this_range = (VerseRange)key;
            if (!this_range.overlaps(that_range)) continue;
            this.store.remove(this_range);
            VerseRange[] vra = VerseRange.remainder(this_range, that_range);
            for (int i = 0; i < vra.length; ++i) {
                this.store.add(vra[i]);
            }
            removed = true;
        }
        if (removed) {
            this.normalize();
        }
        if (this.suppressEvents == 0) {
            this.fireIntervalRemoved(this, that_range.getStart(), that_range.getEnd());
        }
    }

    @Override
    public void retainAll(Key key) {
        this.optimizeWrites();
        TreeSet<VerseRange> new_store = new TreeSet<VerseRange>();
        if (key instanceof RangedPassage) {
            Iterator<VerseRange> that_it = ((RangedPassage)key).rangeIterator(RestrictionType.CHAPTER);
            while (that_it.hasNext()) {
                VerseRange that_range = that_it.next();
                Iterator<VerseRange> this_it = this.rangeIterator(RestrictionType.NONE);
                while (this_it.hasNext()) {
                    VerseRange interstect;
                    VerseRange this_range = this_it.next();
                    if (!this_range.overlaps(that_range) || (interstect = VerseRange.intersection(this_range, that_range)) == null) continue;
                    new_store.add(interstect);
                }
            }
        } else {
            Iterator that_it = key.iterator();
            while (that_it.hasNext()) {
                VerseRange that_range = RangedPassage.toVerseRange(this.getVersification(), that_it.next());
                Iterator<VerseRange> this_it = this.rangeIterator(RestrictionType.NONE);
                while (this_it.hasNext()) {
                    VerseRange interstect;
                    VerseRange this_range = this_it.next();
                    if (!this_range.overlaps(that_range) || (interstect = VerseRange.intersection(this_range, that_range)) == null) continue;
                    new_store.add(interstect);
                }
            }
        }
        this.store = new_store;
        this.normalize();
        this.fireIntervalRemoved(this, null, null);
    }

    @Override
    final void normalize() {
        if (this.skipNormalization != 0) {
            return;
        }
        VerseRange last = null;
        VerseRange next = null;
        TreeSet<VerseRange> new_store = new TreeSet<VerseRange>();
        Iterator<VerseRange> it = this.rangeIterator(RestrictionType.NONE);
        while (it.hasNext()) {
            next = it.next();
            if (last != null && next.adjacentTo(last)) {
                VerseRange merge = new VerseRange(last, next);
                new_store.remove(last);
                new_store.add(merge);
                last = merge;
                continue;
            }
            new_store.add(next);
            last = next;
        }
        this.store = new_store;
    }

    private void writeObject(ObjectOutputStream out) throws IOException {
        out.defaultWriteObject();
        this.writeObjectSupport(out);
    }

    private void readObject(ObjectInputStream in) throws IOException, ClassNotFoundException {
        this.optimizeWrites();
        this.store = new TreeSet<VerseRange>();
        in.defaultReadObject();
        this.readObjectSupport(in);
    }

    private static final class VerseRangeIterator
    implements Iterator<VerseRange> {
        private VerseRange next;
        private RestrictionType restrict;
        private Iterator<VerseRange> real;

        public VerseRangeIterator(Iterator<VerseRange> it, RestrictionType restrict) {
            this.restrict = restrict;
            this.real = it;
        }

        @Override
        public void remove() {
            throw new UnsupportedOperationException();
        }

        @Override
        public boolean hasNext() {
            return this.next != null || this.real.hasNext();
        }

        @Override
        public VerseRange next() {
            if (this.next == null) {
                this.next = this.real.next();
            }
            if (this.next == null) {
                throw new NoSuchElementException();
            }
            if (this.restrict.isSameScope(this.next.getVersification(), this.next.getStart(), this.next.getEnd())) {
                return this.replyNext();
            }
            return this.splitNext();
        }

        private VerseRange replyNext() {
            VerseRange reply = this.next;
            this.next = null;
            return reply;
        }

        private VerseRange splitNext() {
            Iterator<VerseRange> chop = this.next.rangeIterator(this.restrict);
            VerseRange first = chop.next();
            VerseRange[] ranges = VerseRange.remainder(this.next, first);
            assert (ranges.length == 1);
            this.next = ranges[0];
            return first;
        }
    }

    private static final class VerseIterator
    implements Iterator<Key> {
        private Iterator<Key> real;

        public VerseIterator(Versification v11n, Iterator<VerseRange> it) {
            TreeSet<Verse> temp = new TreeSet<Verse>();
            while (it.hasNext()) {
                VerseRange range = it.next();
                int start = range.getStart().getOrdinal();
                int end = range.getCardinality();
                for (int i = 0; i < end; ++i) {
                    temp.add(v11n.decodeOrdinal(start + i));
                }
            }
            this.real = temp.iterator();
        }

        @Override
        public boolean hasNext() {
            return this.real.hasNext();
        }

        @Override
        public Key next() throws NoSuchElementException {
            return this.real.next();
        }

        @Override
        public void remove() throws UnsupportedOperationException {
            throw new UnsupportedOperationException();
        }
    }
}

