/*
 * Decompiled with CFR 0.152.
 */
package org.crosswire.jsword.passage;

import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.util.Iterator;
import java.util.NoSuchElementException;
import java.util.TreeSet;
import org.crosswire.jsword.JSOtherMsg;
import org.crosswire.jsword.passage.AbstractPassage;
import org.crosswire.jsword.passage.Key;
import org.crosswire.jsword.passage.NoSuchVerseException;
import org.crosswire.jsword.passage.Passage;
import org.crosswire.jsword.passage.PassageUtil;
import org.crosswire.jsword.passage.RestrictionType;
import org.crosswire.jsword.passage.Verse;
import org.crosswire.jsword.passage.VerseRange;
import org.crosswire.jsword.versification.Versification;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class PassageTally
extends AbstractPassage {
    public static final int MAX_TALLY = 20000;
    private int size;
    private int total;
    protected int[] board;
    private int max;
    private Order order = Order.BIBLICAL;
    private static final Logger log = LoggerFactory.getLogger(PassageTally.class);
    private static final long serialVersionUID = 3761128240928274229L;

    public PassageTally(Versification v11n) {
        super(v11n);
        this.board = new int[v11n.maximumOrdinal() + 1];
    }

    protected PassageTally(Versification v11n, String refs, Key basis) throws NoSuchVerseException {
        super(v11n, refs);
        this.board = new int[v11n.maximumOrdinal() + 1];
        this.addVerses(refs, basis);
    }

    protected PassageTally(Versification v11n, String refs) throws NoSuchVerseException {
        this(v11n, refs, null);
    }

    @Override
    public boolean isEmpty() {
        return this.size == 0;
    }

    @Override
    public int countVerses() {
        return this.size;
    }

    public void setOrdering(Order order) {
        this.order = order;
    }

    public Order getOrdering() {
        return this.order;
    }

    public int getTotal() {
        return this.total;
    }

    public void setTotal(int total) {
        this.total = total;
    }

    @Override
    public PassageTally clone() {
        PassageTally copy = (PassageTally)super.clone();
        copy.board = (int[])this.board.clone();
        return copy;
    }

    @Override
    public String toString() {
        return this.getName(0);
    }

    @Override
    public String getName() {
        return this.getName(0);
    }

    public String getName(int cnt) {
        int max_count = cnt;
        if (PassageUtil.isPersistentNaming() && this.originalName != null) {
            return this.originalName;
        }
        StringBuilder retcode = new StringBuilder();
        if (this.order == Order.BIBLICAL) {
            Iterator<VerseRange> it = this.rangeIterator(RestrictionType.NONE);
            Verse current = null;
            while (it.hasNext()) {
                VerseRange range = it.next();
                retcode.append(range.getName(current));
                if (it.hasNext()) {
                    retcode.append(", ");
                }
                current = range.getStart();
            }
        } else {
            if (max_count == 0) {
                max_count = Integer.MAX_VALUE;
            }
            OrderedVerseIterator it = new OrderedVerseIterator(this.getVersification(), this.board);
            Key current = null;
            int count = 0;
            while (it.hasNext() && count < max_count) {
                Key verse = (Key)it.next();
                retcode.append(verse.getName(current));
                current = verse;
                if (!it.hasNext() || ++count >= max_count) continue;
                retcode.append(", ");
            }
        }
        return retcode.toString();
    }

    public String getNameAndTally() {
        return this.getNameAndTally(0);
    }

    public String getNameAndTally(int cnt) {
        int max_count = cnt;
        StringBuilder retcode = new StringBuilder();
        if (max_count == 0) {
            max_count = Integer.MAX_VALUE;
        }
        OrderedVerseIterator it = new OrderedVerseIterator(this.getVersification(), this.board);
        int count = 0;
        while (it.hasNext() && count < max_count) {
            Key verse = it.next();
            retcode.append(verse.getName());
            retcode.append(" (");
            retcode.append(100 * it.lastRank() / this.max);
            retcode.append("%)");
            if (!it.hasNext() || ++count >= max_count) continue;
            retcode.append(", ");
        }
        return retcode.toString();
    }

    @Override
    public Iterator<Key> iterator() {
        if (this.order == Order.BIBLICAL) {
            return new VerseIterator();
        }
        return new OrderedVerseIterator(this.getVersification(), this.board);
    }

    @Override
    public Iterator<VerseRange> rangeIterator(RestrictionType restrict) {
        if (this.order == Order.BIBLICAL) {
            return new AbstractPassage.VerseRangeIterator(this.getVersification(), this.iterator(), restrict);
        }
        return new OrderedVerseRangeIterator(this.getVersification(), this.iterator(), this.board);
    }

    @Override
    public boolean contains(Key that) {
        for (Key aKey : that) {
            Verse verse = (Verse)aKey;
            if (this.board[verse.getOrdinal()] != 0) continue;
            return false;
        }
        return true;
    }

    public int getTallyOf(Verse verse) {
        return this.board[verse.getOrdinal()];
    }

    public int getIndexOf(Verse verse) {
        int pos = verse.getOrdinal();
        int tally = this.board[pos];
        return tally > 0 ? pos : -1;
    }

    @Override
    public void add(Key that) {
        this.optimizeWrites();
        this.alterVerseBase(that, 1);
        this.fireIntervalAdded(this, null, null);
    }

    public void add(Key that, int count) {
        this.optimizeWrites();
        this.alterVerseBase(that, count);
        this.fireIntervalAdded(this, null, null);
    }

    public void unAdd(Key that) {
        this.optimizeWrites();
        this.alterVerseBase(that, -1);
        this.fireIntervalRemoved(this, null, null);
    }

    @Override
    public void remove(Key that) {
        this.optimizeWrites();
        for (Key aKey : that) {
            Verse verse = (Verse)aKey;
            this.kill(verse.getOrdinal());
        }
        this.fireIntervalRemoved(this, null, null);
    }

    @Override
    public void addAll(Key that) {
        this.optimizeWrites();
        if (that instanceof PassageTally) {
            PassageTally that_rt = (PassageTally)that;
            int vib = this.getVersification().maximumOrdinal();
            for (int i = 0; i <= vib; ++i) {
                this.increment(i, that_rt.board[i]);
            }
            this.incrementMax(that_rt.max);
        } else {
            for (Key aKey : that) {
                Verse verse = (Verse)aKey;
                this.increment(verse.getOrdinal(), 1);
            }
            this.incrementMax(1);
        }
        this.fireIntervalAdded(this, null, null);
    }

    public void unAddAll(Passage that) {
        this.optimizeWrites();
        if (that instanceof PassageTally) {
            PassageTally that_rt = (PassageTally)that;
            int vib = this.getVersification().maximumOrdinal();
            for (int i = 0; i <= vib; ++i) {
                this.increment(i, -that_rt.board[i]);
            }
        } else {
            for (Key aKey : that) {
                Verse verse = (Verse)aKey;
                this.increment(verse.getOrdinal(), -1);
            }
        }
        this.fireIntervalRemoved(this, null, null);
    }

    @Override
    public void removeAll(Key key) {
        this.optimizeWrites();
        if (key instanceof PassageTally) {
            PassageTally that_rt = (PassageTally)key;
            int vib = this.getVersification().maximumOrdinal();
            for (int i = 0; i <= vib; ++i) {
                if (that_rt.board[i] == 0) continue;
                this.kill(i);
            }
        } else {
            for (Key aKey : key) {
                Verse verse = (Verse)aKey;
                this.kill(verse.getOrdinal());
            }
        }
        this.fireIntervalRemoved(this, null, null);
    }

    @Override
    public void clear() {
        this.optimizeWrites();
        for (int i = 0; i < this.board.length; ++i) {
            this.board[i] = 0;
        }
        this.size = 0;
        this.fireIntervalRemoved(this, null, null);
    }

    @Override
    public Passage trimVerses(int count) {
        this.optimizeWrites();
        int i = 0;
        boolean overflow = false;
        PassageTally remainder = this.clone();
        for (Key verse : this) {
            if (++i > count) {
                this.remove(verse);
                overflow = true;
                continue;
            }
            remainder.remove(verse);
        }
        if (overflow) {
            return remainder;
        }
        return null;
    }

    public void flatten() {
        this.optimizeWrites();
        for (int i = 0; i < this.board.length; ++i) {
            if (this.board[i] == 0) continue;
            this.board[i] = 1;
        }
        this.max = 1;
    }

    @Override
    public void blur(int verses, RestrictionType restrict) {
        assert (verses >= 0);
        this.optimizeWrites();
        this.raiseEventSuppresion();
        this.raiseNormalizeProtection();
        if (!restrict.equals((Object)RestrictionType.NONE)) {
            log.warn("Restrict={} is not properly supported.", (Object)restrict);
            PassageTally temp = this.clone();
            Iterator<VerseRange> it = temp.rangeIterator(RestrictionType.NONE);
            while (it.hasNext()) {
                VerseRange range = it.next();
                for (int i = 0; i <= verses; ++i) {
                    this.add(restrict.blur(this.getVersification(), range, i, i));
                }
            }
        } else {
            int[] new_board = new int[this.board.length];
            for (int i = 0; i < this.board.length; ++i) {
                int k;
                int j;
                if (this.board[i] == 0) continue;
                for (j = -verses; j < 0; ++j) {
                    k = i + j;
                    if (k < 0) continue;
                    int n = k;
                    new_board[n] = new_board[n] + (this.board[i] + verses + j);
                }
                int n = i;
                new_board[n] = new_board[n] + (this.board[i] + verses);
                for (j = 1; j <= verses; ++j) {
                    k = i + j;
                    if (k >= this.board.length - 1) continue;
                    int n2 = k;
                    new_board[n2] = new_board[n2] + (this.board[i] + verses - j);
                }
            }
            this.board = new_board;
        }
        this.resetMax();
        this.lowerNormalizeProtection();
        if (this.lowerEventSuppressionAndTest()) {
            this.fireIntervalAdded(this, null, null);
        }
    }

    private void resetMax() {
        this.optimizeWrites();
        this.max = 0;
        this.size = 0;
        for (int i = 0; i < this.board.length; ++i) {
            if (this.board[i] > 0) {
                ++this.size;
            }
            if (this.board[i] <= this.max) continue;
            this.max = this.board[i];
        }
    }

    private void alterVerseBase(Key that, int tally) {
        for (Key aKey : that) {
            Verse verse = (Verse)aKey;
            this.increment(verse.getOrdinal(), tally);
        }
        if (tally > 0) {
            this.incrementMax(tally);
        }
    }

    private void increment(int ord, int tally) {
        boolean exists = this.board[ord] > 0;
        int n = ord;
        this.board[n] = this.board[n] + tally;
        if (this.board[ord] > 20000) {
            this.board[ord] = 20000;
        }
        if (this.board[ord] < 0) {
            this.board[ord] = 0;
        }
        if (exists && this.board[ord] == 0) {
            --this.size;
        } else if (!exists && this.board[ord] > 0) {
            ++this.size;
        }
    }

    private void incrementMax(int tally) {
        this.max += tally;
        if (this.max > 20000) {
            this.max = 20000;
        }
        if (this.max < 0) {
            this.max = 0;
        }
    }

    private void kill(int ord) {
        if (this.board[ord] > 0) {
            --this.size;
        }
        this.board[ord] = 0;
    }

    private void writeObject(ObjectOutputStream out) throws IOException {
        out.defaultWriteObject();
        this.writeObjectSupport(out);
    }

    private void readObject(ObjectInputStream in) throws IOException, ClassNotFoundException {
        this.optimizeWrites();
        in.defaultReadObject();
        this.readObjectSupport(in);
    }

    private static class TalliedVerseRange
    implements Comparable<TalliedVerseRange> {
        protected VerseRange range;
        protected int tally;

        public TalliedVerseRange(VerseRange range, int tally) {
            this.range = range;
            this.tally = tally;
        }

        public int hashCode() {
            int result = 31 + this.tally;
            return 31 * result + (this.range == null ? 0 : this.range.hashCode());
        }

        public boolean equals(Object obj) {
            if (this == obj) {
                return true;
            }
            if (obj == null) {
                return false;
            }
            if (this.getClass() != obj.getClass()) {
                return false;
            }
            TalliedVerseRange other = (TalliedVerseRange)obj;
            if (this.tally != other.tally) {
                return false;
            }
            return !(this.range == null ? other.range != null : !this.range.equals(other.range));
        }

        @Override
        public int compareTo(TalliedVerseRange that) {
            if (that.tally == this.tally) {
                return this.range.compareTo(that.range);
            }
            return that.tally - this.tally;
        }
    }

    private static final class OrderedVerseRangeIterator<T>
    implements Iterator<VerseRange> {
        private TalliedVerseRange last;
        private Iterator<TalliedVerseRange> it;

        public OrderedVerseRangeIterator(Versification v11n, Iterator<Key> vit, int[] board) {
            TreeSet<TalliedVerseRange> output = new TreeSet<TalliedVerseRange>();
            AbstractPassage.VerseRangeIterator rit = new AbstractPassage.VerseRangeIterator(v11n, vit, RestrictionType.NONE);
            while (rit.hasNext()) {
                VerseRange range = (VerseRange)rit.next();
                int rank = 0;
                for (Verse verse : range) {
                    int temp = board[verse.getOrdinal()];
                    if (temp <= rank) continue;
                    rank = temp;
                }
                output.add(new TalliedVerseRange(range, rank));
            }
            this.it = output.iterator();
            this.last = null;
        }

        @Override
        public boolean hasNext() {
            return this.it.hasNext();
        }

        @Override
        public VerseRange next() throws NoSuchElementException {
            this.last = this.it.next();
            return this.last.range;
        }

        @Override
        public void remove() throws UnsupportedOperationException {
            throw new UnsupportedOperationException();
        }
    }

    private static class TalliedVerse
    implements Comparable<TalliedVerse> {
        protected int ord;
        protected int tally;

        public TalliedVerse(int ord, int tally) {
            this.ord = ord;
            this.tally = tally;
        }

        public int hashCode() {
            int result = 31 + this.ord;
            return 31 * result + this.tally;
        }

        public boolean equals(Object obj) {
            if (this == obj) {
                return true;
            }
            if (obj == null) {
                return false;
            }
            if (this.getClass() != obj.getClass()) {
                return false;
            }
            TalliedVerse other = (TalliedVerse)obj;
            if (this.tally != other.tally) {
                return false;
            }
            return this.ord == other.ord;
        }

        @Override
        public int compareTo(TalliedVerse that) {
            if (that.tally == this.tally) {
                return this.ord - that.ord;
            }
            return that.tally - this.tally;
        }
    }

    private static final class OrderedVerseIterator
    implements Iterator<Key> {
        private Versification referenceSystem;
        private TalliedVerse last;
        private Iterator<TalliedVerse> it;

        protected OrderedVerseIterator(Versification v11n, int[] board) {
            this.referenceSystem = v11n;
            TreeSet<TalliedVerse> output = new TreeSet<TalliedVerse>();
            int vib = board.length - 1;
            for (int i = 0; i <= vib; ++i) {
                if (board[i] == 0) continue;
                output.add(new TalliedVerse(i, board[i]));
            }
            this.it = output.iterator();
            this.last = null;
        }

        @Override
        public boolean hasNext() {
            return this.it.hasNext();
        }

        @Override
        public Key next() throws NoSuchElementException {
            this.last = this.it.next();
            return this.referenceSystem.decodeOrdinal(this.last.ord);
        }

        @Override
        public void remove() throws UnsupportedOperationException {
            throw new UnsupportedOperationException();
        }

        public int lastRank() throws NoSuchElementException {
            if (this.last != null) {
                return this.last.tally;
            }
            throw new NoSuchElementException(JSOtherMsg.lookupText("nextElement() has not been called yet.", new Object[0]));
        }
    }

    private final class VerseIterator
    implements Iterator<Key> {
        private int next;

        public VerseIterator() {
            this.calculateNext();
        }

        @Override
        public boolean hasNext() {
            return this.next <= PassageTally.this.board.length - 1;
        }

        @Override
        public Key next() throws NoSuchElementException {
            if (this.next >= PassageTally.this.board.length) {
                throw new NoSuchElementException();
            }
            Verse retcode = PassageTally.this.getVersification().decodeOrdinal(this.next);
            this.calculateNext();
            return retcode;
        }

        @Override
        public void remove() throws UnsupportedOperationException {
            throw new UnsupportedOperationException();
        }

        private void calculateNext() {
            do {
                ++this.next;
            } while (this.next < PassageTally.this.board.length && PassageTally.this.board[this.next] == 0);
        }
    }

    public static enum Order {
        BIBLICAL,
        TALLY;

    }
}

