/*
 * Decompiled with CFR 0.152.
 */
package org.crosswire.jsword.index.query;

import org.crosswire.jsword.book.BookException;
import org.crosswire.jsword.index.Index;
import org.crosswire.jsword.index.query.AbstractBinaryQuery;
import org.crosswire.jsword.index.query.Query;
import org.crosswire.jsword.passage.Key;
import org.crosswire.jsword.passage.RestrictionType;

public class BlurQuery
extends AbstractBinaryQuery {
    private int factor;

    public BlurQuery(Query theLeftQuery, Query theRightQuery, int theFactor) {
        super(theLeftQuery, theRightQuery);
        this.factor = theFactor;
    }

    @Override
    public Key find(Index index) throws BookException {
        Key left = this.getLeftQuery().find(index);
        if (left.isEmpty()) {
            return left;
        }
        Key right = this.getRightQuery().find(index);
        if (right.isEmpty()) {
            return right;
        }
        right.blur(this.factor, RestrictionType.getDefaultBlurRestriction());
        left.retainAll(right);
        return left;
    }

    public int getFactor() {
        return this.factor;
    }
}

