/*
 * Decompiled with CFR 0.152.
 */
package org.crosswire.jsword.bridge;

import org.crosswire.jsword.book.Book;
import org.crosswire.jsword.book.BookCategory;
import org.crosswire.jsword.book.Books;
import org.crosswire.jsword.passage.Key;
import org.crosswire.jsword.versification.BookName;

public class BibleScope {
    private Book book;
    private Key inScope;
    private Key outScope;

    public BibleScope(Book book) {
        this.book = book;
    }

    public Key getInScope() {
        this.computeScope();
        return this.inScope;
    }

    public Key getOutOfScope() {
        this.computeScope();
        return this.outScope;
    }

    private void computeScope() {
        if (this.inScope == null) {
            Key all = this.book.getGlobalKeyList();
            this.inScope = this.book.createEmptyKeyList();
            this.outScope = this.book.createEmptyKeyList();
            for (Key key : all) {
                if (this.book.contains(key)) {
                    this.inScope.addAll(key);
                    continue;
                }
                this.outScope.addAll(key);
            }
        }
    }

    public static void report(Book b) {
        if (!b.getBookCategory().equals((Object)BookCategory.BIBLE) && !b.getBookCategory().equals((Object)BookCategory.COMMENTARY)) {
            System.err.println(b.getInitials() + " is not a Bible or Commentary");
        }
        BibleScope scope = new BibleScope(b);
        BookName.setFullBookName(false);
        System.out.println('[' + b.getInitials() + ']');
        System.out.println("InScope=" + scope.getInScope().getOsisRef());
        System.out.println("OutScope=" + scope.getOutOfScope().getOsisRef());
    }

    public static void main(String[] args) {
        if (args.length != 1) {
            BibleScope.usage();
            return;
        }
        System.err.println("BibleScope " + args[0]);
        Book b = Books.installed().getBook(args[0]);
        if (b == null) {
            System.err.println("Book not found");
            return;
        }
        BibleScope.report(b);
    }

    public static void usage() {
        System.err.println("Usage: BibleScope book");
    }
}

