/*
 * Decompiled with CFR 0.152.
 */
package org.crosswire.jsword.book.sword.state;

import java.io.File;
import java.io.IOException;
import java.io.RandomAccessFile;
import java.net.URI;
import org.crosswire.common.util.IOUtil;
import org.crosswire.common.util.Reporter;
import org.crosswire.jsword.JSMsg;
import org.crosswire.jsword.book.BookException;
import org.crosswire.jsword.book.sword.RawLDBackend;
import org.crosswire.jsword.book.sword.SwordBookMetaData;
import org.crosswire.jsword.book.sword.SwordUtil;
import org.crosswire.jsword.book.sword.state.AbstractOpenFileState;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class RawLDBackendState
extends AbstractOpenFileState {
    private int size = -1;
    private File idxFile;
    private RandomAccessFile idxRaf;
    private File datFile;
    private RandomAccessFile datRaf;
    private SwordBookMetaData bookMetaData;
    private static final Logger log = LoggerFactory.getLogger(RawLDBackend.class);

    RawLDBackendState(SwordBookMetaData bookMetaData) throws BookException {
        this.bookMetaData = bookMetaData;
        URI path = null;
        try {
            path = SwordUtil.getExpandedDataPath(bookMetaData);
        }
        catch (BookException e) {
            Reporter.informUser((Object)this, e);
            throw e;
        }
        try {
            this.idxFile = new File(path.getPath() + ".idx");
            this.datFile = new File(path.getPath() + ".dat");
            if (!this.idxFile.canRead()) {
                Reporter.informUser((Object)this, new BookException(JSMsg.gettext("Error reading {0}", this.idxFile.getAbsolutePath())));
                return;
            }
            if (!this.datFile.canRead()) {
                BookException prob = new BookException(JSMsg.gettext("Error reading {0}", this.datFile.getAbsolutePath()));
                Reporter.informUser((Object)this, prob);
                throw prob;
            }
            this.idxRaf = new RandomAccessFile(this.idxFile, "r");
            this.datRaf = new RandomAccessFile(this.datFile, "r");
        }
        catch (IOException ex) {
            IOUtil.close(this.idxRaf);
            IOUtil.close(this.datRaf);
            log.error("failed to open files", (Throwable)ex);
            this.idxRaf = null;
            this.datRaf = null;
            throw new BookException(JSMsg.gettext("Error reading {0}", this.datFile.getAbsolutePath()), ex);
        }
    }

    @Override
    public void releaseResources() {
        this.size = -1;
        IOUtil.close(this.idxRaf);
        IOUtil.close(this.datRaf);
        this.idxRaf = null;
        this.datRaf = null;
    }

    public int getSize() {
        return this.size;
    }

    public File getIdxFile() {
        return this.idxFile;
    }

    public RandomAccessFile getIdxRaf() {
        return this.idxRaf;
    }

    public RandomAccessFile getDatRaf() {
        return this.datRaf;
    }

    public void setSize(int size) {
        this.size = size;
    }

    @Override
    public SwordBookMetaData getBookMetaData() {
        return this.bookMetaData;
    }
}

