/*
 * Decompiled with CFR 0.152.
 */
package org.crosswire.jsword.book.readings;

import java.text.MessageFormat;
import java.util.Calendar;
import java.util.Date;
import org.crosswire.common.icu.DateFormatter;
import org.crosswire.jsword.passage.DefaultLeafKeyList;
import org.crosswire.jsword.passage.Key;

public class ReadingsKey
extends DefaultLeafKeyList {
    private Date date;
    private static final MessageFormat KEY_FORMAT = new MessageFormat("{0,number,00}.{1,number,00}");
    private static final long serialVersionUID = -5500401548068844993L;

    protected ReadingsKey(String text, String osisName, Key parent) {
        super(text, osisName, parent);
        DateFormatter formatter = DateFormatter.getDateInstance();
        formatter.setLenient(true);
        this.date = formatter.parse(text);
    }

    protected ReadingsKey(Date date) {
        super(DateFormatter.getDateInstance().format(date), DateFormatter.getSimpleDateInstance("d.MMMM").format(date));
        this.date = date;
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!obj.getClass().equals(this.getClass())) {
            return false;
        }
        ReadingsKey that = (ReadingsKey)obj;
        return this.getName().equals(that.getName());
    }

    @Override
    public int hashCode() {
        return this.date.hashCode();
    }

    @Override
    public int compareTo(Key obj) {
        ReadingsKey that = (ReadingsKey)obj;
        return this.date.compareTo(that.date);
    }

    @Override
    public ReadingsKey clone() {
        return (ReadingsKey)super.clone();
    }

    public static String external2internal(Calendar externalKey) {
        Object[] objs = new Object[]{1 + externalKey.get(2), externalKey.get(5)};
        return KEY_FORMAT.format(objs);
    }
}

