/*
 * Decompiled with CFR 0.152.
 */
package org.crosswire.jsword.book.install.sword;

import java.io.IOException;
import org.apache.commons.net.ftp.FTPClient;
import org.apache.commons.net.ftp.FTPFile;
import org.apache.commons.net.ftp.FTPReply;

public final class FTPExample {
    private FTPExample() {
    }

    static void copyDirectory(FTPClient ftpClient, String sourceDir, String module, String destDir, String currentDir) throws IOException {
        FTPFile[] subFiles;
        String dirToList = module;
        if (!"".equals(currentDir)) {
            dirToList = dirToList + "/" + currentDir;
        }
        if ((subFiles = ftpClient.listFiles(sourceDir + '/' + dirToList)) != null && subFiles.length > 0) {
            for (FTPFile aFile : subFiles) {
                String currentFileName = aFile.getName();
                if (".".equals(currentFileName) || "..".equals(currentFileName)) continue;
                if (aFile.isFile()) {
                    FTPExample.copyFile(ftpClient, sourceDir, dirToList + '/' + currentFileName, destDir);
                    continue;
                }
                if (!aFile.isDirectory() || "lucene".equalsIgnoreCase(currentFileName)) continue;
                System.out.println("mkdir " + destDir + dirToList + '/' + currentFileName + "/");
                FTPExample.copyDirectory(ftpClient, sourceDir, dirToList, destDir, currentFileName);
            }
        }
    }

    static void copyFile(FTPClient ftpClient, String sourceDir, String file, String destDir) throws IOException {
        System.out.println("cp " + sourceDir + '/' + file + ' ' + destDir + '/' + file);
    }

    static long getSize(FTPClient ftpClient, String sourceDir, String module) throws IOException {
        long total = 0L;
        String dirToList = module;
        FTPFile[] subFiles = ftpClient.listFiles(sourceDir + '/' + dirToList);
        if (subFiles != null && subFiles.length > 0) {
            for (FTPFile aFile : subFiles) {
                String currentFileName = aFile.getName();
                if (".".equals(currentFileName) || "..".equals(currentFileName)) continue;
                if (aFile.isFile()) {
                    total += aFile.getSize();
                    continue;
                }
                if (!aFile.isDirectory() || "lucene".equalsIgnoreCase(currentFileName)) continue;
                total += FTPExample.getSize(ftpClient, sourceDir, dirToList);
            }
        }
        return total;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void main(String[] args) {
        String server = "ftp.crosswire.org";
        int port = 21;
        String user = "anonymous";
        String pass = "jsword@crosswire.org";
        String dirToList = "/pub/sword/avraw";
        String confPath = "mods.d/azeri.conf";
        String dataPath = "modules/texts/ztext/azeri";
        FTPClient ftpClient = new FTPClient();
        try {
            ftpClient.connect(server, port);
            int replyCode = ftpClient.getReplyCode();
            if (!FTPReply.isPositiveCompletion((int)replyCode)) {
                System.out.println("Connect failed");
                return;
            }
            boolean success = ftpClient.login(user, pass);
            if (!success) {
                System.out.println("Could not login to the server");
                return;
            }
            ftpClient.setUseEPSVwithIPv4(true);
            FTPExample.copyFile(ftpClient, dirToList, confPath, "/Users/DM/Library/Application Support/Sword");
            System.out.println("Size is " + FTPExample.getSize(ftpClient, dirToList, confPath));
            FTPExample.copyDirectory(ftpClient, dirToList, dataPath, "/Users/DM/Library/Application Support/Sword", "");
            System.out.println("Size is " + FTPExample.getSize(ftpClient, dirToList, dataPath));
        }
        catch (IOException e) {
            System.out.println("Oops! Something wrong happened");
            e.printStackTrace();
        }
        finally {
            try {
                if (ftpClient.isConnected()) {
                    ftpClient.logout();
                    ftpClient.disconnect();
                }
            }
            catch (IOException ex) {
                System.out.println("Oops! Something wrong happened");
                ex.printStackTrace();
            }
        }
    }
}

