/*
 * Decompiled with CFR 0.152.
 */
package org.crosswire.jsword.book.filter.thml;

import java.io.IOException;
import java.io.StringReader;
import java.util.List;
import javax.xml.parsers.ParserConfigurationException;
import javax.xml.parsers.SAXParser;
import javax.xml.parsers.SAXParserFactory;
import org.crosswire.common.xml.XMLUtil;
import org.crosswire.jsword.book.Book;
import org.crosswire.jsword.book.OSISUtil;
import org.crosswire.jsword.book.filter.Filter;
import org.crosswire.jsword.book.filter.thml.CustomHandler;
import org.crosswire.jsword.passage.Key;
import org.jdom2.Content;
import org.jdom2.Element;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.xml.sax.InputSource;
import org.xml.sax.SAXException;
import org.xml.sax.SAXParseException;
import org.xml.sax.helpers.DefaultHandler;

public class THMLFilter
implements Filter {
    private String errorMessage;
    private Exception error;
    private String finalInput;
    private static final Logger log = LoggerFactory.getLogger(THMLFilter.class);

    @Override
    public List<Content> toOSIS(Book book, Key key, String plain) {
        Element ele = this.cleanParse(book, key, plain);
        if (ele == null) {
            if (this.error instanceof SAXParseException) {
                SAXParseException spe = (SAXParseException)this.error;
                int colNumber = spe.getColumnNumber();
                int start = Math.max(0, colNumber - 40);
                int stop = Math.min(this.finalInput.length(), colNumber + 40);
                int here = stop - start;
                log.warn("Could not fix {}({}) by {}: Error here({},{},{}): {}", new Object[]{book.getInitials(), key.getName(), this.errorMessage, Integer.toString(colNumber), Integer.toString(this.finalInput.length()), Integer.toString(here), this.finalInput.substring(start, stop)});
            } else {
                log.warn("Could not fix {}({}) by {}: {}", new Object[]{book.getInitials(), key.getName(), this.errorMessage, this.error.getMessage()});
            }
            ele = OSISUtil.factory().createP();
        }
        return ele.removeContent();
    }

    @Override
    public THMLFilter clone() {
        THMLFilter clone;
        block2: {
            clone = null;
            try {
                clone = (THMLFilter)super.clone();
            }
            catch (CloneNotSupportedException e) {
                if ($assertionsDisabled) break block2;
                throw new AssertionError((Object)e);
            }
        }
        return clone;
    }

    private Element cleanParse(Book book, Key key, String plain) {
        String clean = XMLUtil.cleanAllEntities(plain);
        Element ele = this.parse(book, key, clean, "cleaning entities");
        if (ele == null) {
            ele = this.cleanText(book, key, clean);
        }
        return ele;
    }

    private Element cleanText(Book book, Key key, String plain) {
        String clean = XMLUtil.cleanAllCharacters(plain);
        Element ele = this.parse(book, key, clean, "cleaning text");
        if (ele == null) {
            ele = this.parse(book, key, XMLUtil.closeEmptyTags(clean), "closing empty tags");
        }
        if (ele == null) {
            ele = this.cleanTags(book, key, clean);
        }
        return ele;
    }

    private Element cleanTags(Book book, Key key, String plain) {
        String clean = XMLUtil.cleanAllTags(plain);
        return this.parse(book, key, clean, "cleaning tags");
    }

    private Element parse(Book book, Key key, String plain, String failMessage) {
        Exception ex = null;
        StringBuilder buf = new StringBuilder(15 + plain.length());
        buf.append('<').append("root").append('>').append(plain).append("</").append("root").append('>');
        this.finalInput = buf.toString();
        try {
            StringReader in = new StringReader(this.finalInput);
            InputSource is = new InputSource(in);
            SAXParserFactory spf = SAXParserFactory.newInstance();
            SAXParser parser = spf.newSAXParser();
            CustomHandler handler = new CustomHandler(book, key);
            parser.parse(is, (DefaultHandler)handler);
            return handler.getRootElement();
        }
        catch (SAXParseException e) {
            ex = e;
        }
        catch (SAXException e) {
            ex = e;
        }
        catch (IOException e) {
            ex = e;
        }
        catch (ParserConfigurationException e) {
            ex = e;
        }
        catch (IllegalArgumentException e) {
            ex = e;
        }
        this.errorMessage = failMessage;
        this.error = ex;
        return null;
    }
}

