/*
 * Decompiled with CFR 0.152.
 */
package org.crosswire.jsword.book.filter.thml;

import java.util.HashMap;
import java.util.LinkedList;
import java.util.Locale;
import java.util.Map;
import org.crosswire.jsword.book.Book;
import org.crosswire.jsword.book.DataPolice;
import org.crosswire.jsword.book.filter.thml.ATag;
import org.crosswire.jsword.book.filter.thml.AbbrTag;
import org.crosswire.jsword.book.filter.thml.AliasTag;
import org.crosswire.jsword.book.filter.thml.AnonymousTag;
import org.crosswire.jsword.book.filter.thml.BTag;
import org.crosswire.jsword.book.filter.thml.BigTag;
import org.crosswire.jsword.book.filter.thml.BlockquoteTag;
import org.crosswire.jsword.book.filter.thml.BrTag;
import org.crosswire.jsword.book.filter.thml.CenterTag;
import org.crosswire.jsword.book.filter.thml.CitationTag;
import org.crosswire.jsword.book.filter.thml.DivTag;
import org.crosswire.jsword.book.filter.thml.FontTag;
import org.crosswire.jsword.book.filter.thml.ForeignTag;
import org.crosswire.jsword.book.filter.thml.HTag;
import org.crosswire.jsword.book.filter.thml.HrTag;
import org.crosswire.jsword.book.filter.thml.ITag;
import org.crosswire.jsword.book.filter.thml.IgnoreTag;
import org.crosswire.jsword.book.filter.thml.ImgTag;
import org.crosswire.jsword.book.filter.thml.LiTag;
import org.crosswire.jsword.book.filter.thml.NameTag;
import org.crosswire.jsword.book.filter.thml.NoteTag;
import org.crosswire.jsword.book.filter.thml.OlTag;
import org.crosswire.jsword.book.filter.thml.PTag;
import org.crosswire.jsword.book.filter.thml.PbTag;
import org.crosswire.jsword.book.filter.thml.QTag;
import org.crosswire.jsword.book.filter.thml.RootTag;
import org.crosswire.jsword.book.filter.thml.STag;
import org.crosswire.jsword.book.filter.thml.ScripRefTag;
import org.crosswire.jsword.book.filter.thml.ScriptureTag;
import org.crosswire.jsword.book.filter.thml.SkipTag;
import org.crosswire.jsword.book.filter.thml.SmallTag;
import org.crosswire.jsword.book.filter.thml.SubTag;
import org.crosswire.jsword.book.filter.thml.SupTag;
import org.crosswire.jsword.book.filter.thml.SyncTag;
import org.crosswire.jsword.book.filter.thml.TableTag;
import org.crosswire.jsword.book.filter.thml.Tag;
import org.crosswire.jsword.book.filter.thml.TdTag;
import org.crosswire.jsword.book.filter.thml.TermTag;
import org.crosswire.jsword.book.filter.thml.ThTag;
import org.crosswire.jsword.book.filter.thml.TrTag;
import org.crosswire.jsword.book.filter.thml.TtTag;
import org.crosswire.jsword.book.filter.thml.UTag;
import org.crosswire.jsword.book.filter.thml.UlTag;
import org.crosswire.jsword.book.filter.thml.VerseTag;
import org.crosswire.jsword.passage.Key;
import org.jdom2.Content;
import org.jdom2.Element;
import org.jdom2.Text;
import org.xml.sax.Attributes;
import org.xml.sax.SAXException;
import org.xml.sax.helpers.DefaultHandler;

public class CustomHandler
extends DefaultHandler {
    private Element rootElement;
    private Book book;
    private Key key;
    private LinkedList<Content> stack;
    private static final Map<String, Tag> TAG_MAP = new HashMap<String, Tag>();

    public CustomHandler(Book book, Key key) {
        this.book = book;
        this.key = key;
        this.stack = new LinkedList();
    }

    @Override
    public void startElement(String uri, String localname, String qname, Attributes attrs) throws SAXException {
        Tag t;
        Element ele = null;
        if (!this.stack.isEmpty()) {
            Content top = this.stack.getFirst();
            if (top == null) {
                return;
            }
            if (top instanceof Element) {
                ele = (Element)top;
            }
        }
        if ((t = this.getTag(localname, qname)) != null) {
            this.stack.addFirst((Content)t.processTag(this.book, this.key, ele, attrs));
        }
    }

    @Override
    public void characters(char[] data, int offset, int length) {
        String text = new String(data, offset, length);
        if (this.stack.isEmpty()) {
            this.stack.addFirst((Content)new Text(text));
            return;
        }
        Content top = this.stack.getFirst();
        if (top == null) {
            return;
        }
        if (top instanceof Text) {
            ((Text)top).append(text);
            return;
        }
        if (top instanceof Element) {
            Content last;
            Element current = (Element)top;
            int size = current.getContentSize();
            if (size > 0 && (last = current.getContent(size - 1)) instanceof Text) {
                ((Text)last).append(text);
                return;
            }
            current.addContent((Content)new Text(text));
        }
    }

    @Override
    public void endElement(String uri, String localname, String qname) {
        if (this.stack.isEmpty()) {
            return;
        }
        Content top = this.stack.removeFirst();
        if (top instanceof Element) {
            Element finished = (Element)top;
            Tag t = this.getTag(localname, qname);
            if (t != null) {
                t.processContent(this.book, this.key, finished);
            }
            if (this.stack.isEmpty()) {
                this.rootElement = finished;
            }
        }
    }

    public Element getRootElement() {
        return this.rootElement;
    }

    private Tag getTag(String localname, String qname) {
        String name = qname != null && qname.length() > 0 ? qname : localname;
        Tag t = TAG_MAP.get(name);
        if (t == null && (t = TAG_MAP.get(name.toLowerCase(Locale.ENGLISH))) == null) {
            DataPolice.report(this.book, this.key, "Unknown thml element: " + localname + " qname=" + name);
            t = new AnonymousTag(name);
            TAG_MAP.put(name, t);
            return t;
        }
        return t;
    }

    static {
        Tag[] tags = new Tag[]{new ATag(), new AbbrTag(), new AliasTag("acronym", new AbbrTag()), new AnonymousTag("address"), new SkipTag("applet"), new SkipTag("area"), new BTag(), new SkipTag("base"), new SkipTag("basefont"), new IgnoreTag("bdo"), new BigTag(), new BlockquoteTag(), new IgnoreTag("body"), new BrTag(), new SkipTag("button"), new AnonymousTag("caption"), new CenterTag(), new AnonymousTag("cite"), new AnonymousTag("code"), new SkipTag("col"), new SkipTag("colgroup"), new AliasTag("dd", new LiTag()), new AnonymousTag("del"), new AnonymousTag("dfn"), new DivTag(), new AliasTag("dl", new UlTag()), new AliasTag("dt", new LiTag()), new AliasTag("em", new ITag()), new IgnoreTag("fieldset"), new FontTag(), new SkipTag("form"), new SkipTag("frame"), new SkipTag("frameset"), new AliasTag("h1", new HTag(1)), new AliasTag("h2", new HTag(2)), new AliasTag("h3", new HTag(3)), new AliasTag("h4", new HTag(4)), new AliasTag("h5", new HTag(5)), new AliasTag("h6", new HTag(6)), new SkipTag("head"), new HrTag(), new IgnoreTag("html"), new IgnoreTag("frameset"), new ITag(), new SkipTag("iframe"), new ImgTag(), new SkipTag("input"), new AnonymousTag("ins"), new AnonymousTag("kbd"), new AnonymousTag("label"), new AnonymousTag("legend"), new LiTag(), new SkipTag("link"), new SkipTag("map"), new SkipTag("meta"), new SkipTag("noscript"), new SkipTag("object"), new OlTag(), new SkipTag("optgroup"), new SkipTag("option"), new PTag(), new SkipTag("param"), new IgnoreTag("pre"), new QTag(), new RootTag(), new STag(), new AnonymousTag("samp"), new SkipTag("script"), new SkipTag("select"), new SmallTag(), new IgnoreTag("span"), new AliasTag("strong", new BTag()), new SkipTag("style"), new SubTag(), new SupTag(), new SyncTag(), new TableTag(), new IgnoreTag("tbody"), new TdTag(), new IgnoreTag("tfoot"), new SkipTag("textarea"), new SkipTag("title"), new IgnoreTag("thead"), new ThTag(), new TrTag(), new TtTag(), new UTag(), new UlTag(), new AnonymousTag("var"), new AnonymousTag("added"), new AnonymousTag("attr"), new AnonymousTag("argument"), new CitationTag(), new AnonymousTag("date"), new AnonymousTag("deleted"), new AnonymousTag("def"), new AliasTag("div1", new DivTag(1)), new AliasTag("div2", new DivTag(2)), new AliasTag("div3", new DivTag(3)), new AliasTag("div4", new DivTag(4)), new AliasTag("div5", new DivTag(5)), new AliasTag("div6", new DivTag(6)), new ForeignTag(), new AnonymousTag("index"), new AnonymousTag("insertIndex"), new AnonymousTag("glossary"), new NoteTag(), new NameTag(), new PbTag(), new AnonymousTag("scripCom"), new AnonymousTag("scripContext"), new ScripRefTag(), new ScriptureTag(), new TermTag(), new AnonymousTag("unclear"), new VerseTag()};
        for (int i = 0; i < tags.length; ++i) {
            Tag t = tags[i];
            String tagName = t.getTagName();
            TAG_MAP.put(tagName, t);
        }
    }
}

