/*
 * Decompiled with CFR 0.152.
 */
package org.crosswire.jsword.book.filter;

import java.util.HashMap;
import java.util.Locale;
import java.util.Map;
import org.crosswire.common.util.PluginUtil;
import org.crosswire.jsword.book.filter.Filter;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class FilterFactory {
    private static Map<String, Filter> filters = new HashMap<String, Filter>();
    private static final Logger log = LoggerFactory.getLogger(FilterFactory.class);
    private static volatile Filter deft;

    private FilterFactory() {
    }

    public static Filter getFilter(String lookup) {
        Filter reply = filters.get(lookup.toLowerCase(Locale.ENGLISH));
        if (reply == null) {
            reply = deft;
        }
        return reply.clone();
    }

    public static Filter getDefaultFilter() {
        return deft.clone();
    }

    public static void addFilter(String name, Filter instance) {
        filters.put(name.toLowerCase(Locale.ENGLISH), instance);
    }

    static {
        Map<String, Class<Filter>> map = PluginUtil.getImplementorsMap(Filter.class);
        try {
            Class<Filter> cdeft = map.remove("default");
            deft = cdeft.newInstance();
        }
        catch (InstantiationException e) {
            log.error("Failed to get default filter, will attempt to use first", (Throwable)e);
        }
        catch (IllegalAccessException e) {
            log.error("Failed to get default filter, will attempt to use first", (Throwable)e);
        }
        Filter instance = null;
        for (Map.Entry<String, Class<Filter>> entry : map.entrySet()) {
            try {
                Class<Filter> clazz = entry.getValue();
                instance = clazz.newInstance();
                FilterFactory.addFilter(entry.getKey(), instance);
            }
            catch (InstantiationException ex) {
                log.error("Failed to add filter", (Throwable)ex);
            }
            catch (IllegalAccessException ex) {
                log.error("Failed to add filter", (Throwable)ex);
            }
        }
        if (deft == null) {
            deft = instance;
        }
    }
}

