/*
 * Decompiled with CFR 0.152.
 */
package org.crosswire.jsword.book.basic;

import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Set;
import org.crosswire.common.util.StringUtil;
import org.crosswire.jsword.book.BookData;
import org.crosswire.jsword.book.BookException;
import org.crosswire.jsword.book.BookMetaData;
import org.crosswire.jsword.book.OSISUtil;
import org.crosswire.jsword.book.basic.AbstractBook;
import org.crosswire.jsword.book.filter.Filter;
import org.crosswire.jsword.book.sword.Backend;
import org.crosswire.jsword.book.sword.processing.RawTextToXmlProcessor;
import org.crosswire.jsword.passage.Key;
import org.crosswire.jsword.passage.KeyUtil;
import org.crosswire.jsword.passage.NoSuchKeyException;
import org.crosswire.jsword.passage.Passage;
import org.crosswire.jsword.passage.PassageKeyFactory;
import org.crosswire.jsword.passage.RestrictionType;
import org.crosswire.jsword.passage.Verse;
import org.crosswire.jsword.passage.VerseKey;
import org.crosswire.jsword.passage.VerseRange;
import org.crosswire.jsword.versification.BibleBook;
import org.crosswire.jsword.versification.Versification;
import org.crosswire.jsword.versification.VersificationsMapper;
import org.crosswire.jsword.versification.system.Versifications;
import org.jdom2.Content;
import org.jdom2.Element;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class AbstractPassageBook
extends AbstractBook {
    private String versification;
    private Versification versificationSystem;
    private PassageKeyFactory keyf = PassageKeyFactory.instance();
    private volatile Set<BibleBook> bibleBooks;
    private static final Logger log = LoggerFactory.getLogger(AbstractPassageBook.class);

    public AbstractPassageBook(BookMetaData bmd, Backend backend) {
        super(bmd, backend);
        this.versification = bmd.getProperty("Versification");
    }

    @Override
    public Iterator<Content> getOsisIterator(Key key, final boolean allowEmpty, boolean allowGenTitles) throws BookException {
        final Filter filter = this.getFilter();
        Passage ref = VersificationsMapper.instance().map(KeyUtil.getPassage(key), this.getVersification());
        final boolean showTitles = ref.hasRanges(RestrictionType.CHAPTER) || !allowEmpty && allowGenTitles;
        RawTextToXmlProcessor processor = new RawTextToXmlProcessor(){
            private String previousVerseText = "";

            @Override
            public void preRange(VerseRange range, List<Content> partialDom) {
                if (showTitles) {
                    Element title = OSISUtil.factory().createGeneratedTitle();
                    title.addContent(range.getName());
                    partialDom.add((Content)title);
                }
            }

            @Override
            public void postVerse(Key verse, List<Content> partialDom, String rawText) {
                if ((allowEmpty || rawText.length() > 0) && !this.previousVerseText.equals(rawText)) {
                    List<Content> osisContent = filter.toOSIS(AbstractPassageBook.this, verse, rawText);
                    AbstractPassageBook.this.addOSIS(verse, partialDom, osisContent);
                }
                this.previousVerseText = rawText;
            }

            @Override
            public void init(List<Content> partialDom) {
            }
        };
        return this.getOsis(ref, processor).iterator();
    }

    public void addOSIS(Key key, Element div, List<Content> osisContent) {
        assert (key != null);
        div.addContent(osisContent);
    }

    public void addOSIS(Key key, List<Content> content, List<Content> osisContent) {
        assert (key != null);
        content.addAll(osisContent);
    }

    protected abstract Filter getFilter();

    public void setDocument(Key key, BookData bdata) throws BookException {
        for (Content nextElem : OSISUtil.getFragment(bdata.getOsisFragment())) {
            if (nextElem instanceof Element) {
                Element div = (Element)nextElem;
                for (Content data : div.getContent()) {
                    if (data instanceof Element) {
                        Element overse = (Element)data;
                        String text = OSISUtil.getPlainText(overse);
                        this.setRawText(key, text);
                        continue;
                    }
                    log.error("Ignoring non OSIS/Verse content of DIV.");
                }
                continue;
            }
            log.error("Ignoring non OSIS/Verse content of DIV.");
        }
    }

    @Override
    public boolean isWritable() {
        return false;
    }

    @Override
    public final Key createEmptyKeyList() {
        return this.keyf.createEmptyKeyList(Versifications.instance().getVersification(this.versification));
    }

    @Override
    public Key getValidKey(String name) {
        try {
            return this.getKey(name);
        }
        catch (NoSuchKeyException e) {
            return this.createEmptyKeyList();
        }
    }

    @Override
    public final Key getKey(String text) throws NoSuchKeyException {
        return PassageKeyFactory.instance().getKey(Versifications.instance().getVersification(this.versification), text);
    }

    public Versification getVersification() {
        if (this.versificationSystem == null) {
            this.versificationSystem = Versifications.instance().getVersification(this.getBookMetaData().getProperty("Versification"));
        }
        return this.versificationSystem;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Set<BibleBook> getBibleBooks() {
        if (this.bibleBooks == null) {
            AbstractPassageBook abstractPassageBook = this;
            synchronized (abstractPassageBook) {
                if (this.bibleBooks == null) {
                    this.bibleBooks = this.getBibleBooksInternal();
                }
            }
        }
        return this.bibleBooks;
    }

    private Set<BibleBook> getBibleBooksInternal() {
        Set<BibleBook> books;
        String list = this.getBookMetaData().getProperty("BookList");
        if (list == null) {
            books = this.calculateBibleBookList();
            String listOfBooks = this.toString(books);
            this.putProperty("BookList", listOfBooks);
        } else {
            books = this.fromString(list);
        }
        return books;
    }

    private Set<BibleBook> fromString(String list) {
        String[] bookOsis;
        LinkedHashSet<BibleBook> books = new LinkedHashSet<BibleBook>(list.length() / 2);
        for (String s : bookOsis = StringUtil.split(list, ' ')) {
            books.add(BibleBook.fromExactOSIS(s));
        }
        return books;
    }

    private String toString(Set<BibleBook> books) {
        StringBuilder sb = new StringBuilder(books.size() * 8);
        Iterator<BibleBook> iterator = books.iterator();
        while (iterator.hasNext()) {
            BibleBook b = iterator.next();
            sb.append(b.getOSIS());
            if (!iterator.hasNext()) continue;
            sb.append(' ');
        }
        return sb.toString();
    }

    private Set<BibleBook> calculateBibleBookList() {
        BookMetaData bookMetaData = this.getBookMetaData();
        VerseKey scope = (VerseKey)this.getScope();
        if (scope == null) {
            return new HashSet<BibleBook>();
        }
        LinkedHashSet<BibleBook> bookList = new LinkedHashSet<BibleBook>();
        Versification v11n = Versifications.instance().getVersification(bookMetaData.getProperty("Versification"));
        Iterator<BibleBook> v11nBookIterator = v11n.getBookIterator();
        while (v11nBookIterator.hasNext()) {
            BibleBook bibleBook = v11nBookIterator.next();
            if (!scope.contains(new Verse(v11n, bibleBook, 1, 1)) && !scope.contains(new Verse(v11n, bibleBook, 1, 2))) continue;
            bookList.add(bibleBook);
        }
        return bookList;
    }
}

