/*
 * Decompiled with CFR 0.152.
 */
package org.crosswire.jsword.book;

import java.util.Collections;
import java.util.List;
import java.util.concurrent.CopyOnWriteArrayList;
import org.crosswire.common.util.CollectionUtil;
import org.crosswire.jsword.book.Book;
import org.crosswire.jsword.book.BookFilter;
import org.crosswire.jsword.book.BookFilterIterator;
import org.crosswire.jsword.book.BookList;
import org.crosswire.jsword.book.BooksEvent;
import org.crosswire.jsword.book.BooksListener;

public abstract class AbstractBookList
implements BookList {
    private List<BooksListener> listeners = new CopyOnWriteArrayList<BooksListener>();

    @Override
    public List<Book> getBooks(BookFilter filter) {
        List<Book> temp = CollectionUtil.createList(new BookFilterIterator(this.getBooks(), filter));
        return Collections.unmodifiableList(temp);
    }

    @Override
    public void addBooksListener(BooksListener li) {
        this.listeners.add(li);
    }

    @Override
    public void removeBooksListener(BooksListener li) {
        this.listeners.remove(li);
    }

    protected void fireBooksChanged(Object source, Book book, boolean added) {
        BooksEvent ev = new BooksEvent(source, book, added);
        for (BooksListener listener : this.listeners) {
            if (added) {
                listener.bookAdded(ev);
                continue;
            }
            listener.bookRemoved(ev);
        }
    }
}

