/*
 * Decompiled with CFR 0.152.
 */
package org.crosswire.common.xml;

import java.io.Writer;
import org.crosswire.common.xml.FormatType;
import org.crosswire.common.xml.PrettySerializingContentHandler;
import org.crosswire.common.xml.XMLUtil;

public class HTMLSerializingContentHandler
extends PrettySerializingContentHandler {
    public HTMLSerializingContentHandler() {
    }

    public HTMLSerializingContentHandler(FormatType theFormat) {
        super(theFormat);
    }

    public HTMLSerializingContentHandler(FormatType theFormat, Writer theWriter) {
        super(theFormat, theWriter);
    }

    protected String decorateTagName(String tagName) {
        StringBuffer buf = new StringBuffer(50);
        buf.append("<font class='tag'>");
        buf.append(super.decorateTagName(tagName));
        buf.append("</font>");
        return buf.toString();
    }

    protected String decorateAttributeName(String attrName) {
        StringBuffer buf = new StringBuffer(50);
        buf.append("<font class='attr'>");
        buf.append(super.decorateAttributeName(attrName));
        buf.append("</font>");
        return buf.toString();
    }

    protected String decorateAttributeValue(String attrValue) {
        StringBuffer buf = new StringBuffer(50);
        buf.append("<font class='value'>");
        buf.append(super.decorateAttributeValue(attrValue));
        buf.append("</font>");
        return buf.toString();
    }

    protected String decorateCharacters(String characters) {
        StringBuffer buf = new StringBuffer(50);
        buf.append("<font class='text'>");
        buf.append(XMLUtil.escape(super.decorateCharacters(characters)).replaceAll("\n", "<br>"));
        buf.append("</font>");
        return buf.toString();
    }

    protected String decorateIndent(int indentLevel) {
        StringBuffer buf = new StringBuffer(100);
        buf.append("<font class='indent'>");
        buf.append(super.decorateIndent(indentLevel).replaceAll("\t", "&nbsp;&nbsp;&nbsp;&nbsp;"));
        buf.append("</font>");
        return buf.toString();
    }

    public void startDocument() {
        this.write("<html><head><style type='text/css'>\nFONT.tag    { font-family:courier new, monospaced; color:#666699; font-weight:bold; }\nFONT.attr   { font-family:courier new, monospaced; color:#669966; font-weight:bold; }\nFONT.value  { font-family:courier new, monospaced; color:#669966; font-style:italic; }\nFONT.indent { }\nFONT.text   { font-family:courier new, monospaced; background:#FFFF99; }\n</style></head><body>\n");
    }

    public void endDocument() {
        this.write("</body></head>");
    }

    protected String getEmptyTagEnd() {
        return XMLUtil.escape(super.getEmptyTagEnd());
    }

    protected String getEndTagStart() {
        return XMLUtil.escape(super.getEndTagStart());
    }

    protected String getPIEnd() {
        return XMLUtil.escape(super.getPIEnd());
    }

    protected String getPIStart() {
        return XMLUtil.escape(super.getPIStart());
    }

    protected String getTagEnd() {
        return XMLUtil.escape(super.getTagEnd());
    }

    protected String getTagStart() {
        return XMLUtil.escape(super.getTagStart());
    }

    protected String getNewline() {
        return "<br>";
    }
}

