/*
 * Decompiled with CFR 0.152.
 */
package org.crosswire.common.util;

import java.util.Locale;
import java.util.MissingResourceException;
import java.util.ResourceBundle;
import org.crosswire.common.util.CWClassLoader;
import org.crosswire.common.util.StringUtil;

public class Languages {
    public static final String DEFAULT_LANG_CODE = "en";
    private static final String UNKNOWN_LANG_CODE = "und";
    private static ResourceBundle languages;
    static final /* synthetic */ boolean $assertionsDisabled;

    private Languages() {
    }

    public static boolean isValidLanguage(String iso639Code) {
        try {
            String code = Languages.getLanguageCode(iso639Code);
            if (code == DEFAULT_LANG_CODE || code == UNKNOWN_LANG_CODE) {
                return true;
            }
            languages.getString(code);
            return true;
        }
        catch (MissingResourceException e) {
            return false;
        }
    }

    public static String getLanguageName(String iso639Code) {
        String code = Languages.getLanguageCode(iso639Code);
        try {
            return languages.getString(code);
        }
        catch (MissingResourceException e) {
            return code;
        }
    }

    public static String getLanguageCode(String input) {
        String lookup = input;
        if (lookup == null || lookup.length() == 0) {
            return DEFAULT_LANG_CODE;
        }
        if (lookup.indexOf(95) != -1) {
            String[] locale = StringUtil.split(lookup, '_');
            return Languages.getLanguageCode(locale[0]);
        }
        if (lookup.startsWith("x-") || lookup.startsWith("X-") || lookup.length() > 3) {
            return UNKNOWN_LANG_CODE;
        }
        return lookup;
    }

    static {
        block2: {
            $assertionsDisabled = !Languages.class.desiredAssertionStatus();
            try {
                languages = ResourceBundle.getBundle("iso639", Locale.getDefault(), CWClassLoader.instance());
            }
            catch (MissingResourceException e) {
                if ($assertionsDisabled) break block2;
                throw new AssertionError();
            }
        }
    }
}

